/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import javafx.scene.control.Control;

public class ExportAgainOrganizationEntityListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.REPEAT;
    }

    public double getWeight() {
        return 51.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return context.getIndexType().equals(OrganizationIndex.class);
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        Dialog.confirm(context, (String)Messages.Reexport_for_selected_organizations, () -> Notifications.get().submitTask(() -> {
            try {
                ModelService service = (ModelService)RpcServiceManager.get().getService(ModelService.class);
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                for (OrganizationIndex idx : selectedItems) {
                    service.createExportDocument(sic, idx.getSource());
                }
            }
            catch (ServiceException e) {
                if (e.getMessage().equals("no settings with createDocuments and sendData equals true")) {
                    Message message = new Message();
                    L10nMessage l10nMessage = new L10nMessage();
                    l10nMessage.setKey(Messages.Reexport_error);
                    message.setMessage(l10nMessage);
                    message.setType(MessageType.ERROR);
                    Notifications.get().showMessages(new Message[]{message});
                }
                ErrorHandler.handle((Throwable)e);
            }
        }, Messages.Organizations_exporting));
    }

    public String getId() {
        return "organization-export-againList";
    }
}

