/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.ExportAgainServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.ExportEntityAction;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpace;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import javafx.scene.control.Control;

public class ExportAgainShipmentEntityAction
implements RootEntityAction {
    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        try {
            Notifications.get().enqueueAsyncTask(new ExportAgainServerTaskHandler(context.getData().getContainer().toReference(), Messages.Shipment_is_exported));
        }
        catch (Exception e) {
            if (e.getMessage().equals("no settings with createDocuments and sendData equals true")) {
                Message message = new Message();
                L10nMessage l10nMessage = new L10nMessage();
                l10nMessage.setKey(Messages.Reexport_error);
                message.setMessage(l10nMessage);
                message.setType(MessageType.ERROR);
                Notifications.get().showMessages(new Message[]{message});
            }
            ErrorHandler.handle((Throwable)e);
        }
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.REPEAT;
    }

    public double getWeight() {
        return new ExportEntityAction().getWeight() + 1.0;
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.getEditor() instanceof ShipmentSpace && context.isLastVersion();
    }

    public String getId() {
        return "shipment-export-again";
    }
}

