/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportEntityHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;

public class ExportEntityListAction<E extends BaseEntity, I extends EntityIndex<E>>
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EXPORT;
    }

    public double getWeight() {
        return 3.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return !BookingFile.class.getName().equals(ett.getId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ArrayList<TableColumnSettings> columnSettings = new ArrayList<TableColumnSettings>();
        context.getTableView().getColumns().forEach(column -> {
            TableColumnSettings settings;
            if (column.isVisible() && (settings = TableColumnSettings.getFor((TableColumn)column)) != null) {
                columnSettings.add(settings);
            }
        });
        ExportEntityHelper.showExportEntitiesDialog((Node)source, context.getIndexType(), context.getSelectedItems(), context.buildQuery(), columnSettings);
    }

    public String getId() {
        return "entity-exportInList";
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return new AclQuery(StandardRestrictionResourceOperations.EXPORT.getId(), ett.getId());
    }
}

