/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.FinanceConsolidatedDocumentsParametersPane;
import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.finance.document.FinanceConsolidatedDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceConsolidatedDocumentsCreateAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 33.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ShipmentIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List shipmentRefs = context.getSelectedItems().stream().map(ShipmentIndex::getSource).map(ref -> new MiscUtil.Pair(ref, (Object)Boolean.TRUE)).collect(Collectors.toList());
        Notifications.get().submitTask(() -> {
            FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData shipmentsData = ((FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class)).getFinanceConsolidatedDocumentsShipmentsData(ServiceInvocationContext.get(), shipmentRefs);
            final FinanceConsolidatedDocumentsParametersPane.FinanceConsolidatedDocumentsParameters parameters = new FinanceConsolidatedDocumentsParametersPane.FinanceConsolidatedDocumentsParameters();
            parameters.setDate(new Date());
            parameters.setShipmentsData(shipmentsData);
            parameters.getShipments().clear();
            parameters.getShipments().addAll(shipmentRefs);
            FxUtil.waitForFxThread(() -> {
                FinanceConsolidatedDocumentsParametersPane pane = new FinanceConsolidatedDocumentsParametersPane();
                pane.readData(parameters);
                new Dialog().setTitle(Messages.financeConsolidatedDocumentsCreate).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
                    pane.writeData(parameters);
                    Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                        protected String getTitle() {
                            return Messages.financeConsolidatedDocumentsCreateProcess;
                        }

                        protected String getTaskClassName() {
                            return "com.gridnine.xtrip.server.fx.async.entityactions.FinanceConsolidatedDocumentCreateAsyncTask";
                        }

                        protected Serializable getTaskParameters() {
                            FinanceConsolidatedDocumentsCreateTaskParameters taskParameters = new FinanceConsolidatedDocumentsCreateTaskParameters();
                            taskParameters.setDate(parameters.getDate());
                            taskParameters.setUseDelegate(parameters.getUseDelegate());
                            taskParameters.setUseFacsimile(parameters.getUseFacsimile());
                            taskParameters.getShipments().addAll(parameters.getShipments().stream().filter(MiscUtil.Pair::getSecond).map(MiscUtil.Pair::getFirst).collect(Collectors.toList()));
                            return taskParameters;
                        }

                        protected void onCompleted(Object object, List<Message> log) {
                            FinanceDocumentsCreateTaskResult result = (FinanceDocumentsCreateTaskResult)object;
                            if (result.getChangeData() != null) {
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                            }
                            for (int i = 0; i < result.getDocuments().size(); ++i) {
                                RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                            }
                        }
                    });
                }, (BooleanExpression)pane.validProperty()).setExpandToParent(true).show((Node)source);
            });
        }, context.getMutex());
    }

    public String getId() {
        return "finance-consolidated-documents-create";
    }
}

