/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.ShipmentsAttachTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsAttachTaskResult;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceDocumentDetachAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public String getId() {
        return "finance-document-detach";
    }

    public double getWeight() {
        return 252.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && FinanceDocument.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        if (context.getMode() != EditingMode.EDIT && context.getMode() != EditingMode.VIEW) {
            return false;
        }
        if (context.getData() == null || context.getData().getContainer() == null) {
            return false;
        }
        FinanceDocument financeDocument = (FinanceDocument)context.getData().getContainer().getEntity();
        return (FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)financeDocument.getType()) || FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)financeDocument.getType())) && !financeDocument.getRelatedShipments().isEmpty();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        FinanceDocument financeDocument = (FinanceDocument)context.getData().getContainer().getEntity();
        if (FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)financeDocument.getType())) {
            this.detachFinancePrepaymentDocument(source, context, alt);
        }
        if (FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)financeDocument.getType())) {
            this.detachShipments(source, context, alt);
        }
    }

    public void detachFinancePrepaymentDocument(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityContainer financeDocumentContainer = context.getData().getContainer();
        MultiEntityWidget widget = new MultiEntityWidget(Shipment.class, false);
        widget.setNoNulls(true);
        widget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(ShipmentIndex.class);
            result.getSortings().put(ShipmentIndex.Property.date.name(), SortOrder.ASC);
            result.getSearchCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments().stream().map(EntityReference::getUid).toArray()));
            for (EntityReference shipment : widget.getValues()) {
                result.getSearchCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)shipment.getUid()));
            }
            result.getPatternSearchFields().add(ShipmentIndex.Property.number.name());
            ListParametersHelper.setFilters(result, ShipmentIndex.Property.date.name(), ShipmentIndex.Property.agent.name(), ShipmentIndex.Property.customer.name(), ShipmentIndex.Property.number.name(), ShipmentIndex.Property.supplier.name(), ShipmentIndex.Property.payed.name());
            ListParametersHelper.setColumns(result, ShipmentIndex.Property.date.name(), ShipmentIndex.Property.agent.name(), ShipmentIndex.Property.customer.name(), ShipmentIndex.Property.number.name(), ShipmentIndex.Property.supplier.name(), ShipmentIndex.Property.totalAmount.name(), ShipmentIndex.Property.totalPayedAmount.name(), ShipmentIndex.Property.payed.name());
            return result;
        });
        new Dialog().setTitle(Messages.Select_shipments).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose, () -> Notifications.get().submitTask(() -> {
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_REFERENCE.name(), financeDocumentContainer.toReference());
            contextMap.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), new ArrayList(widget.getValues()));
            Set<String> returnKeys = Collections.singleton(IBusStandardContextKeys.CHANGED_DATA.name());
            Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance-documents:detach", contextMap, returnKeys);
            ChangeData data = (ChangeData)ibusResult.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (data != null) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
            }
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Shipments_detached, (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading), (BooleanExpression)Bindings.isNotEmpty((ObservableList)widget.getValues())).addButton(DialogButtonStyle.DECLINE).show((Node)source);
    }

    public void detachShipments(Control source, RootEntityPane<?, ?> context, boolean alt) {
        final EntityContainer financeDocumentContainer = context.getData().getContainer();
        final MultiEntityWidget widget = new MultiEntityWidget(Shipment.class, false);
        widget.setNoNulls(true);
        widget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(ShipmentIndex.class);
            result.getSortings().put(ShipmentIndex.Property.date.name(), SortOrder.ASC);
            result.getSearchCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", (Collection)((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments().stream().map(EntityReference::getUid).collect(Collectors.toList())));
            result.getPatternSearchFields().add(FinanceDocumentRecordIndex.Property.number.name());
            ListParametersHelper.setFilters(result, ShipmentIndex.Property.date.name(), ShipmentIndex.Property.agent.name(), ShipmentIndex.Property.customer.name(), ShipmentIndex.Property.number.name(), ShipmentIndex.Property.supplier.name());
            ListParametersHelper.setColumns(result, ShipmentIndex.Property.date.name(), ShipmentIndex.Property.agent.name(), ShipmentIndex.Property.customer.name(), ShipmentIndex.Property.number.name(), ShipmentIndex.Property.supplier.name(), ShipmentIndex.Property.totalAmount.name());
            return result;
        });
        if (((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments().size() == 1) {
            widget.getValues().add(CollectionUtil.head((Iterable)((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments()));
        }
        new Dialog().setTitle(Messages.Select_shipments).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose, () -> Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.shipmentsDetachProcess;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.ShipmentsDetachAsyncTask";
            }

            protected Serializable getTaskParameters() {
                ShipmentsAttachTaskParameters parameters = new ShipmentsAttachTaskParameters();
                parameters.setFinanceDocument(financeDocumentContainer.toReference());
                parameters.getShipments().clear();
                parameters.getShipments().addAll(widget.getValues());
                return parameters;
            }

            protected void onCompleted(Object object, List<Message> messages) {
                ShipmentsAttachTaskResult result = (ShipmentsAttachTaskResult)object;
                if (result.getChangeData() != null) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                }
            }
        }), (BooleanExpression)Bindings.isNotEmpty((ObservableList)widget.getValues())).addButton(DialogButtonStyle.DECLINE).show((Node)source);
    }
}

