/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentCustomParameterVM;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentDataPanel;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentMainDataPanel;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsShipmentDataPanel;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsShipmentDataPanelController;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsShipmentDataPanelVM;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.finance.ShipmentUIFinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateFromShipmentTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceDocumentsCreateFromShipmentAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.FINDOCS;
    }

    public double getWeight() {
        return 400.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() == EditingMode.EDIT;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> this.doAction(source, context));
    }

    private void doAction(Control source, RootEntityPane<?, ?> context) {
        final EntityContainer shipment = context.getData().getContainer();
        List<FinanceDocumentType> financeDocumentTypes = Arrays.asList(FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.CORRECTION_DOCUMENT, FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.STANDARD_BILL, FinanceDocumentType.UNIVERSAL_DOCUMENT);
        Date date = ((Shipment)shipment.getEntity()).getDate();
        ShipmentUIData supplement = (ShipmentUIData)context.getData().getSupplement();
        List shipmentDocumentTypes = supplement.getFinanceDocuments().stream().map(ShipmentUIFinanceDocumentData::getType).collect(Collectors.toList());
        List availableTypes = financeDocumentTypes.stream().filter(finDocType -> !shipmentDocumentTypes.contains(finDocType)).collect(Collectors.toList());
        final FinanceDocumentsShipmentDataPanelVM parameters = new FinanceDocumentsShipmentDataPanelVM();
        parameters.getMainParameters().setDate(DateUtils.asLocalDate((Date)date));
        FinanceDocumentsShipmentDataPanelController controller = new FinanceDocumentsShipmentDataPanelController(false);
        FinanceDocumentsShipmentDataPanel pane = controller.getView();
        ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
        BooleanBinding binding = Bindings.createBooleanBinding(() -> ((FinanceDocumentMainDataPanel)pane.getMainParametersCard().getContent()).getDateNode().getValue() != null && ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().getValue() != null && ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTemplateNode().getValue() != null, (Observable[])new Observable[]{((FinanceDocumentMainDataPanel)pane.getMainParametersCard().getContent()).getDateNode().valueProperty(), ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().valueProperty(), ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTemplateNode().valueProperty()});
        valid.bind((ObservableValue)binding);
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
                ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getBillingItemIncludeModeNode().setValue(null);
            }
            if (newValue != FinanceDocumentType.UNIVERSAL_DOCUMENT) {
                ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getUniversalDocumentStatusNode().setValue(null);
                valid.bind((ObservableValue)binding);
            }
            if (newValue == FinanceDocumentType.UNIVERSAL_DOCUMENT) {
                valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> ((FinanceDocumentMainDataPanel)pane.getMainParametersCard().getContent()).getDateNode().getValue() != null && ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().getValue() != null && ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTemplateNode().getValue() != null && ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getUniversalDocumentStatusNode().getValue() != null, (Observable[])new Observable[]{((FinanceDocumentMainDataPanel)pane.getMainParametersCard().getContent()).getDateNode().valueProperty(), ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().valueProperty(), ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTemplateNode().valueProperty(), ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getUniversalDocumentStatusNode().valueProperty()}));
            }
            ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getBillingItemIncludeModeNode().getViewState().setNotEditable(newValue != FinanceDocumentType.ACCEPTANCE_CERTIFICATE);
            ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getUniversalDocumentStatusNode().getViewState().setNotEditable(newValue != FinanceDocumentType.UNIVERSAL_DOCUMENT);
        });
        parameters.setValid(valid);
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().setItemsSupplier(() -> availableTypes);
        if (!availableTypes.isEmpty()) {
            parameters.getFinanceDocumentParameters().setType((FinanceDocumentType)availableTypes.get(0));
        }
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTemplateNode().setListParametersSupplier(() -> {
            IndexListParameters templateParameters = new IndexListParameters();
            templateParameters.setIndexType(TemplateDocumentIndex.class);
            templateParameters.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
            templateParameters.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.financeDocumentType.name(), (Object)((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getTypeNode().getValue()));
            TableColumnSettings titleColumn = new TableColumnSettings();
            titleColumn.setId(TemplateDocumentIndex.Property.title.name());
            templateParameters.getColumns().add(titleColumn);
            TableColumnSettings typeColumn = new TableColumnSettings();
            typeColumn.setId(TemplateDocumentIndex.Property.type.name());
            templateParameters.getColumns().add(typeColumn);
            return templateParameters;
        });
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getDisableCustomerQuotesNode().setConverter(Converters.boolConverter((String)Messages.disableQuotes, (String)Messages.enableQuotes));
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getNotDisplayTitleContractNumberNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getNotGroupByServiceTypeNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
        ((FinanceDocumentDataPanel)pane.getFinanceDocumentParametersCard().getContent()).getNotGroupByProductNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
        controller.readData(parameters);
        new Dialog().setTitle(Messages.financeDocumentsCreate).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
            controller.writeData(parameters);
            Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                protected String getTitle() {
                    return Messages.financeDocumentsCreateProcess;
                }

                protected String getTaskClassName() {
                    return "com.gridnine.xtrip.server.fx.async.entityactions.FinanceDocumentsCreateFromShipmentAsyncTask";
                }

                protected Serializable getTaskParameters() {
                    FinanceDocumentsCreateFromShipmentTaskParameters taskParameters = new FinanceDocumentsCreateFromShipmentTaskParameters();
                    taskParameters.setDate(DateUtils.asDate((LocalDate)parameters.getMainParameters().getDate()));
                    taskParameters.setUseDelegate(Boolean.valueOf(parameters.getFinanceDocumentParameters().isUseDelegate()));
                    taskParameters.setUseFacsimile(Boolean.valueOf(parameters.getFinanceDocumentParameters().isUseFacsimile()));
                    taskParameters.setShipmentReference(shipment.toReference());
                    taskParameters.setFinanceDocumentType(parameters.getFinanceDocumentParameters().getType());
                    taskParameters.setTemplate(parameters.getFinanceDocumentParameters().getTemplate());
                    taskParameters.setBillingItemIncludeMode(parameters.getFinanceDocumentParameters().getBillingItemIncludeMode());
                    taskParameters.setVatViewMode(parameters.getFinanceDocumentParameters().getVatViewMode());
                    taskParameters.setGroupByTraveller(parameters.getFinanceDocumentParameters().isGroupByTraveller());
                    taskParameters.setNotGroupByProduct(parameters.getFinanceDocumentParameters().isNotGroupByProduct());
                    taskParameters.setMergeBillingItems(parameters.getFinanceDocumentParameters().getMergeBillingItems());
                    taskParameters.setDisableCustomerQuotes(parameters.getFinanceDocumentParameters().isDisableCustomerQuotes());
                    taskParameters.setDisplayContract(parameters.getFinanceDocumentParameters().isDisplayContract());
                    taskParameters.setNotDisplayTitleContractNumber(parameters.getFinanceDocumentParameters().isNotDisplayTitleContractNumber());
                    taskParameters.setNotGroupByServiceType(parameters.getFinanceDocumentParameters().isNotGroupByServiceType());
                    taskParameters.setInvertSign(parameters.getFinanceDocumentParameters().isInvertSign());
                    taskParameters.setVendorDocument(parameters.getFinanceDocumentParameters().isVendorDocument());
                    taskParameters.setCaptionTemplate(parameters.getFinanceDocumentParameters().getCaptionTemplate());
                    taskParameters.setUniversalDocumentStatus(parameters.getFinanceDocumentParameters().getUniversalDocumentStatus());
                    for (FinanceDocumentCustomParameterVM parameterVM : parameters.getFinanceDocumentParameters().getCustomParameters()) {
                        taskParameters.getCustomParameters().put(parameterVM.getParameterKey(), parameterVM.getParameterValue());
                    }
                    return taskParameters;
                }

                protected void onCompleted(Object onject, List<Message> messages) {
                    FinanceDocumentsCreateTaskResult result = (FinanceDocumentsCreateTaskResult)onject;
                    if (result.getChangeData() != null) {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                    }
                    for (int i = 0; i < result.getDocuments().size(); ++i) {
                        RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                    }
                }
            });
        }, (BooleanExpression)((ReadOnlyBooleanWrapper)pane.validProperty().get()).getReadOnlyProperty()).setExpandToParent(true).show((Node)source);
    }

    public String getId() {
        return "finance-documents-add";
    }
}

