/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainer;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceDocumentsRenderAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.FINANCE_DOCUMENTS_RENDER;
    }

    public String getId() {
        return "finance-documents-render";
    }

    public double getWeight() {
        return 250.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && FinanceDocument.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() == EditingMode.EDIT || context.getMode() == EditingMode.VIEW;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> Dialog.confirm((Node)source, (String)Messages.Dialog_confirm_render_credit_slip, () -> {
            EntityContainer financeDocumentCtr = context.getData().getContainer();
            HashMap<String, EntityReference> contextMap = new HashMap<String, EntityReference>();
            contextMap.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), financeDocumentCtr.toReference());
            Notifications.get().submitTask(() -> {
                Map tempMap = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance-documents:render-and-save", contextMap, Collections.singleton("messages"));
                contextMap.clear();
                contextMap.putAll(tempMap);
                FxUtil.waitForFxThread(() -> {
                    ArrayList messages = new ArrayList();
                    messages.addAll(((Map)contextMap.get("messages")).values());
                    Notifications.get().showMessages(messages);
                    Notifications.get().submitTask(() -> {
                        context.reloadData();
                        FxUtil.waitForFxThread(() -> ((FinanceDocumentContainer)context.getEditor()).getDocumentCard().setCollapsed(false));
                    }, Messages.Notifications_getting_data);
                });
            }, Messages.Notifications_getting_data);
        }));
    }
}

