/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class MailDocumentSendAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.MAIL_DOCUMENT_SEND;
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && context.getEntityHandler().getEntityClass().equals(MailDocument.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> Dialog.confirm((Node)context, (String)Messages.Start_sending_mails_again, null, (String)Messages.Action_Start, () -> Notifications.get().submitTask(() -> {
            EntityReference ref = context.getData().getContainer().toReference();
            ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).sendMailDocument(ServiceInvocationContext.get(), ref);
        }, context.getMutex()), null));
    }

    public String getId() {
        return "send-maildocument";
    }
}

