/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.MigrateRulesTask;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettingsIndex;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class MigrateRulesListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.MIGRATE_RULES;
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return context.getIndexType().equals(RulesMigrationSettingsIndex.class);
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Dialog.confirm(context, (String)Messages.Start_the_migration_for_the_selected_settings, null, (String)Messages.Action_Start, () -> {
            List selectedItems = context.getSelectedItems();
            Notifications.get().enqueueAsyncTask((ClientTask)new MigrateRulesTask(selectedItems.stream().map(RulesMigrationSettingsIndex::getSource).collect(Collectors.toList())));
        }, null);
    }

    public String getId() {
        return "migrate-rules-list";
    }
}

