/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationEmployeeCategoriesPane;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGroupVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGroupsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationOSIPane;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSSRPane;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSettingsEmployeeCategoriesVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.client.fx.standard.tasks.OrganizationReplaceDetailsListTask;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.BeneficiaryCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationReplaceDetailsType;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.system.model.RegionalType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class OrganizationReplaceDetailsListAction
implements IndexListAction {
    public double getWeight() {
        return 50.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.UPDATE;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return OrganizationIndex.class.equals((Object)context.getIndexType());
    }

    public String getId() {
        return "organization-replace-details";
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ObservableSet selectedTypes = FXCollections.observableSet((Object[])new OrganizationReplaceDetailsType[0]);
        TableWidget tableWidget = new TableWidget(false);
        tableWidget.setItemsProvider(() -> new ReplaceDetail());
        tableWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
        tableWidget.setColumns(this.createTableColumns((Set<OrganizationReplaceDetailsType>)selectedTypes));
        tableWidget.setOnRowsAction(event -> {
            if (event.getTarget() != tableWidget) {
                return;
            }
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex();
                ComboBoxWidget typeWidget = (ComboBoxWidget)((ComboBoxWidgetColumn)tableWidget.getColumn("type")).getWidget(rowIndex);
                RendererWidget valueWidget = (RendererWidget)((RendererWidgetColumn)tableWidget.getColumn("value")).getWidget(rowIndex);
                typeWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        TypeWrapper wrapper = this.createWrapper((OrganizationReplaceDetailsType)newValue);
                        valueWidget.setRenderer(wrapper.getRenderer());
                        this.updateSelectedNames((TableWidget<ReplaceDetail>)tableWidget, (Set<OrganizationReplaceDetailsType>)selectedTypes);
                        wrapper.setListParametersSupplier(valueWidget.getValueNode());
                        valueWidget.setValue(null);
                    }
                });
            } else if (event.getEventType().equals(TableRowEvent.ROW_REMOVE)) {
                this.updateSelectedNames((TableWidget<ReplaceDetail>)tableWidget, (Set<OrganizationReplaceDetailsType>)selectedTypes);
            }
        });
        tableWidget.addRow(0);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Change_of_requisites);
        dialog.setBody((Node)tableWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Change, () -> this.write(tableWidget.getRowsData(), context), (BooleanExpression)Bindings.isNotEmpty((ObservableSet)selectedTypes)).setExpandToParent(true).show((Node)source);
    }

    private void updateSelectedNames(TableWidget<ReplaceDetail> tableWidget, Set<OrganizationReplaceDetailsType> selectedNames) {
        selectedNames.clear();
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("type");
        IntStream.range(0, tableWidget.getRowsCount()).forEach(idx -> selectedNames.add((OrganizationReplaceDetailsType)((ComboBoxWidget)nameColumn.getWidget(idx)).getValue()));
    }

    private List<TableWidgetColumn<ReplaceDetail, ?>> createTableColumns(Set<OrganizationReplaceDetailsType> selectedTypes) {
        ArrayList result = new ArrayList();
        Set organizationRegionalPropertiesTypes = Collections.singleton(RegionalType.RU);
        if (Prefetched.getData().getRegionalSettings() != null && !Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes().isEmpty()) {
            organizationRegionalPropertiesTypes = Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes();
        }
        List<Object> replaceDetailsTypes = Arrays.asList(OrganizationReplaceDetailsType.values());
        if (!organizationRegionalPropertiesTypes.contains(RegionalType.KZ)) {
            replaceDetailsTypes = replaceDetailsTypes.stream().filter(type -> type != OrganizationReplaceDetailsType.BENEFICIARY_CODE).collect(Collectors.toList());
        }
        ComboBoxWidgetColumn col = new ComboBoxWidgetColumn(ReplaceDetail::getType, (rec$, x$0) -> ((ReplaceDetail)rec$).setType(x$0));
        col.setId("type");
        col.setCaption(Messages.Field_Name);
        col.setPrefWidthEm(Double.valueOf(100.0));
        col.setLive(true);
        col.setNoNulls(true);
        List<Object> allowedTypes = replaceDetailsTypes;
        col.setItemsSupplier(Suppliers.createEnumSupplier(OrganizationReplaceDetailsType.class, type -> !selectedTypes.contains(type) && allowedTypes.contains(type)));
        result.add((TableWidgetColumn<ReplaceDetail, ?>)col);
        col = new RendererWidgetColumn(rec$ -> ((ReplaceDetail)rec$).getValue(), (rec$, x$0) -> ((ReplaceDetail)rec$).setValue(x$0));
        col.setId("value");
        col.setCaption(Messages.New_value);
        col.setPrefWidthEm(Double.valueOf(100.0));
        result.add((TableWidgetColumn<ReplaceDetail, ?>)col);
        return result;
    }

    public void write(Collection<ReplaceDetail> rowsData, IndexListPane<?, ?> context) {
        List selectedItems = context.getSelectedItems();
        Notifications.get().enqueueAsyncTask((ClientTask)new OrganizationReplaceDetailsListTask(selectedItems.stream().map(OrganizationIndex::getSource).collect(Collectors.toList()), rowsData.stream().filter(replaceDetail -> replaceDetail.getType() != null && replaceDetail.getConvertedValue() != null).collect(Collectors.toMap(ReplaceDetail::getType, ReplaceDetail::getConvertedValue, (first, second) -> first))));
    }

    TypeWrapper createWrapper(OrganizationReplaceDetailsType type) {
        switch (type) {
            case HOLDING: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_HOLDING;
                    }

                    @Override
                    void setListParametersSupplier(Node node) {
                        StandardNodeRenderer.ENTITYBOX_HOLDING.setListParametersSupplier(node, ControllerInterceptorsHelper::getHoldings);
                    }
                };
            }
            case PROFILE_GROUP: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                return new OrganizationGroupsPanel(readonly).getGroupTableNode();
                            }

                            public Object getValue(Node node) {
                                return ((TableWidget)node).getRowsData();
                            }

                            public void setValue(Node node, Object value) {
                                TableWidget widget = (TableWidget)node;
                                widget.getRowsData().clear();
                                if (value != null) {
                                    widget.getRowsData().addAll((Collection)value);
                                }
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((TableWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }
                };
            }
            case EMPLOYEE_CATEGORIES: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                return new OrganizationEmployeeCategoriesPane(readonly).getContent();
                            }

                            public Object getValue(Node node) {
                                return ((TableWidget)node).getRowsData();
                            }

                            public void setValue(Node node, Object value) {
                                TableWidget widget = (TableWidget)node;
                                widget.getRowsData().clear();
                                if (value != null) {
                                    widget.getRowsData().addAll((Collection)value);
                                }
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((TableWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }
                };
            }
            case OSI: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                return new OrganizationOSIPane(readonly).getContent();
                            }

                            public Object getValue(Node node) {
                                return ((TableWidget)node).getRowsData();
                            }

                            public void setValue(Node node, Object value) {
                                TableWidget widget = (TableWidget)node;
                                widget.getRowsData().clear();
                                if (value != null) {
                                    widget.getRowsData().addAll((Collection)value);
                                }
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((TableWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }
                };
            }
            case SSR: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                return new OrganizationSSRPane(readonly).getContent();
                            }

                            public Object getValue(Node node) {
                                return ((TableWidget)node).getRowsData();
                            }

                            public void setValue(Node node, Object value) {
                                TableWidget widget = (TableWidget)node;
                                widget.getRowsData().clear();
                                if (value != null) {
                                    widget.getRowsData().addAll((Collection)value);
                                }
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((TableWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }
                };
            }
            case BENEFICIARY_CODE: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
                                comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(BeneficiaryCode.class));
                                comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
                                return comboBoxWidget;
                            }

                            public Object getValue(Node node) {
                                return node != null ? ((ComboBoxWidget)node).getValue() : null;
                            }

                            public void setValue(Node node, Object value) {
                                ((ComboBoxWidget)node).setValue((Object)((BeneficiaryCode)value));
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }
                };
            }
        }
        throw Xeption.forDeveloper((String)("unsupported type: " + type), (Object[])new Object[0]);
    }

    private static class ReplaceDetail {
        private OrganizationReplaceDetailsType type;
        private Object value;

        private ReplaceDetail() {
        }

        public OrganizationReplaceDetailsType getType() {
            return this.type;
        }

        private void setType(OrganizationReplaceDetailsType type) {
            this.type = type;
        }

        private Object getValue() {
            return this.value;
        }

        private void setValue(Object param) {
            this.value = param;
        }

        Object getConvertedValue() {
            switch (this.type) {
                case OSI: {
                    return ((Collection)this.value).stream().map(vm -> {
                        SabreProfileCommand2Osi result = new SabreProfileCommand2Osi();
                        result.setLineType(vm.getLineType());
                        result.setEntry1(vm.getAirline());
                        result.setEntry2(vm.getText());
                        return result;
                    }).collect(Collectors.toList());
                }
                case SSR: {
                    return ((Collection)this.value).stream().map(vm -> {
                        SabreProfileCommand4SSR result = new SabreProfileCommand4SSR();
                        result.setLineType(vm.getLineType());
                        result.setSsrCode(vm.getCode());
                        result.setSsrInfo(vm.getText());
                        return result;
                    }).collect(Collectors.toList());
                }
                case PROFILE_GROUP: {
                    return ((Collection)this.value).stream().map(OrganizationGroupVM::getGroup).collect(Collectors.toList());
                }
                case EMPLOYEE_CATEGORIES: {
                    return ((Collection)this.value).stream().map(OrganizationSettingsEmployeeCategoriesVM::getEmployeeCategories).map(name -> {
                        EmployeeCategory category = new EmployeeCategory();
                        category.getName().getValues().putAll(name.getValues());
                        return category;
                    }).collect(Collectors.toList());
                }
            }
            return this.value;
        }
    }

    private static abstract class TypeWrapper {
        private TypeWrapper() {
        }

        abstract NodeRenderer getRenderer();

        void setListParametersSupplier(Node node) {
        }
    }
}

