/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductRefundCreditSlipDialog;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javafx.scene.control.Control;

public class ProductRefundCreditSlipListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(CommonProductIndex.class, AeroexpressTicketIndex.class, InsuranceAccidentIndex.class, UniversalProductIndex.class, DeliveryIndex.class, MainHotelProductIndex.class, InsuranceTouristicIndex.class, RailwayCrimeaMco.class, VisaProductIndex.class, AgencyMemoProductIndex.class, TransferIndex.class, ProductIndex.class, RailwayProductIndex.class, CarRentalProductIndex.class, MCOFeesIndex.class);

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.PRODUCT_REFUND_CREDIT_SLIP;
    }

    public double getWeight() {
        return 66.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Notifications.get().submitTask(() -> {
            HashMap<BaseProduct, EntityContainer<BookingFile>> productsToProcess = new HashMap<BaseProduct, EntityContainer<BookingFile>>();
            ArrayList<BaseProduct> productsToExclude = new ArrayList<BaseProduct>();
            List selectedItems = context.getSelectedItems();
            for (Object item : selectedItems) {
                BaseProduct product;
                EntityReference bfRef = item.getSource();
                EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
                BookingFile bookingFile = (BookingFile)bfCtr.getEntity();
                if (bookingFile == null || (product = BookingHelper.findProductByUid((String)item.getNavigationKey(), (BookingFile)bookingFile)) == null) continue;
                ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
                if (ProductStatus.REFUND == productHandler.getStatus(product) || ProductStatus.SELL == productHandler.getStatus(product) && ProductCategory.MCO == productHandler.getProductCategory(product) && MCOCategory.PENALTY == productHandler.getMCOCategory(product)) {
                    productsToProcess.put(product, (EntityContainer<BookingFile>)bfCtr);
                    continue;
                }
                productsToExclude.add(product);
            }
            if (productsToExclude.size() > 0) {
                Notifications.get().showFlashNotification(Messages.Cannot_create_RKO_Not_in_Return, "");
            } else {
                List<BaseProduct> MCOs = this.findPenaltyMCOs(productsToProcess.keySet());
                for (BaseProduct mco : MCOs) {
                    if (productsToProcess.containsKey(mco)) continue;
                    EntityContainer bookingFile = productsToProcess.values().stream().filter(Objects::nonNull).filter(bfCont -> ((BookingFile)bfCont.getEntity()).getReservations().contains(mco.getReservation())).findFirst().orElse(null);
                    productsToProcess.put(mco, (EntityContainer<BookingFile>)bookingFile);
                }
                ProductRefundCreditSlipDialog dialog = new ProductRefundCreditSlipDialog(source, productsToProcess);
                FxUtil.submitToFxThread(dialog::showDialog);
            }
        }, context.getMutex());
    }

    public String getId() {
        return "product-refund-credit-slip-list";
    }

    private List<BaseProduct> findPenaltyMCOs(Collection<BaseProduct> products) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        for (BaseProduct product : products) {
            List connectedProducts = BookingHelper.getConnectedProducts((BaseProduct)product);
            for (BaseProduct connectedProduct : connectedProducts) {
                ProductHandler connectedProductHandler = HandlersRegistry.get().findProductHandler(connectedProduct.getClass());
                List relatedProducts = connectedProductHandler.getRelatedProducts(connectedProduct);
                if (!relatedProducts.contains(product) || ProductCategory.MCO != connectedProductHandler.getProductCategory(connectedProduct) || MCOCategory.PENALTY != connectedProductHandler.getMCOCategory(connectedProduct)) continue;
                result.add(connectedProduct);
            }
        }
        return result;
    }
}

