/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizeOrganizationListServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.ArrayList;
import java.util.Date;
import javafx.scene.control.Control;

public class SabreProfilesContractSynchronizeAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.SABRE_SYNC;
    }

    public double getWeight() {
        return 33.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Contract.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return Prefetched.getData().getSabreProfilesSettings().isSyncActive();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        ArrayList<EntityReference<Organization>> orgRefs = new ArrayList<EntityReference<Organization>>();
        if (dtp.getContainer() != null && dtp.getContainer().getEntity() != null) {
            for (ContractCustomerInfo tcci : ((Contract)dtp.getContainer().getEntity()).getCustomers()) {
                if (tcci.getCustomer() == null || tcci.getStartDate() != null && !tcci.getStartDate().before(new Date()) || tcci.getEndDate() != null && !tcci.getEndDate().after(new Date())) continue;
                orgRefs.add((EntityReference<Organization>)tcci.getCustomer());
            }
        }
        SabreProfilesSynchronizeOrganizationListServerTaskHandler.enqueue(orgRefs, Messages.Synchronize_existing_customers);
    }

    public String getId() {
        return "contract-synch-sabre-profiles";
    }
}

