/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.standard.entity.ShipmentsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import javafx.scene.control.Control;

public class ShipmentUpdateAction
implements RootEntityAction {
    public String getId() {
        return "shipment-update";
    }

    public double getWeight() {
        return 200.0;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.UPDATE;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE && context.getMode() != EditingMode.VIEW;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            EntityContainer shipmentContainer = context.getData().getContainer();
            if (shipmentContainer != null) {
                ShipmentsHelper.updateShipment((EntityReference<Shipment>)shipmentContainer.toReference());
            }
        });
    }
}

