/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentsProductsExcludeActionFilterPanel;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentsProductsExcludeDialogPanelController;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentsProductsExcludeDialogPanelProductsTableVM;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsExcludeTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsExcludeTaskResult;
import com.gridnine.xtrip.common.fx.rpc.ShipmentsService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ShipmentsProductsExcludeAction
implements RootEntityAction {
    public String getId() {
        return "shipments-products-exclude";
    }

    public double getWeight() {
        return 200.0;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.SHIPMENTS_PRODUCTS_EXCLUDE;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        if (context.getMode() == EditingMode.CREATE || context.getMode() == EditingMode.VIEW || context.getData() == null) {
            return false;
        }
        EntityContainer shipmentContainer = context.getData().getContainer();
        ShipmentUIData supplement = (ShipmentUIData)context.getData().getSupplement();
        return ((Shipment)shipmentContainer.getEntity()).getCorrectionShipments().isEmpty() && ((Shipment)shipmentContainer.getEntity()).getPaymentItems().isEmpty() && supplement.getFinanceDocuments().stream().noneMatch(finDoc -> FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)finDoc.getType()));
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            final EntityContainer shipmentContainer = context.getData().getContainer();
            if (shipmentContainer != null) {
                Shipment shipment = (Shipment)shipmentContainer.getEntity();
                Notifications.get().submitTask(() -> {
                    Map datas = ((ShipmentsService)RpcServiceManager.get().getService(ShipmentsService.class)).getProductDatas(ServiceInvocationContext.get(), shipment.getBillingItems());
                    FxUtil.waitForFxThread(() -> {
                        SimpleIntegerProperty count = new SimpleIntegerProperty();
                        final ShipmentsProductsExcludeDialogPanelController controller = new ShipmentsProductsExcludeDialogPanelController(false);
                        ((BigTableWidget)controller.getProducts().getView()).setControlButtonsAvailability(ControlsPane.NONE);
                        ((BigTableWidget)controller.getProducts().getView()).setFiltering(() -> new ShipmentsProductsExcludeActionFilterPanel(false), filterPanel -> vm -> {
                            String searchValue = filterPanel.getProductNode().getValue();
                            return ControllerInterceptorsHelper.matches(searchValue, vm.getProduct());
                        }, true);
                        final BooleanValueWidget removeEmptyShipmentWidget = (BooleanValueWidget)controller.getOtherProperties().getView().getRemoveEmptyShipmentCell().getPayload();
                        removeEmptyShipmentWidget.getViewState().setReadonly(true);
                        ((BigTableWidget)controller.getProducts().getView()).getColumn("exclude").getListeners().add((arg_0, arg_1, arg_2) -> ShipmentsProductsExcludeAction.lambda$null$4((IntegerProperty)count, datas, removeEmptyShipmentWidget, arg_0, arg_1, arg_2));
                        List values = datas.entrySet().stream().sorted(MiscUtil.comparator(item -> ((ShipmentsService.ProductData)item.getValue()).getProduct(), (Comparator)FinanceDocumentsHelper.productComparator)).map(item -> {
                            ShipmentsProductsExcludeDialogPanelProductsTableVM value = new ShipmentsProductsExcludeDialogPanelProductsTableVM();
                            value.setProduct((NestedEntityReference)item.getKey());
                            value.setExclude(false);
                            return value;
                        }).collect(Collectors.toList());
                        controller.getProducts().readData(values);
                        new Dialog().setTitle(Messages.shipmentsProductsExclude).setBody((Node)controller.getView()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.exclude, () -> Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                            protected String getTitle() {
                                return Messages.shipmentsProductsExcludeProcess;
                            }

                            protected String getTaskClassName() {
                                return "com.gridnine.xtrip.server.fx.async.entityactions.ShipmentsProductsExcludeAsyncTask";
                            }

                            protected Serializable getTaskParameters() {
                                ShipmentsProductsExcludeTaskParameters parameters = new ShipmentsProductsExcludeTaskParameters();
                                parameters.getProductBatches().clear();
                                parameters.getProductBatches().putAll(((BigTableWidget)controller.getProducts().getView()).getRowsData().stream().filter(item -> item.isExclude()).collect(Collectors.toMap(item -> item.getProduct(), item -> Collections.singleton(shipmentContainer.toReference()))));
                                parameters.setRemoveEmptyShipment(removeEmptyShipmentWidget.getValue());
                                return parameters;
                            }

                            protected void onCompleted(Object object, List<Message> messages) {
                                ShipmentsProductsExcludeTaskResult result = (ShipmentsProductsExcludeTaskResult)object;
                                if (result.getChangeData() != null) {
                                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                                }
                                for (int i = 0; i < result.getDocuments().size(); ++i) {
                                    RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                                }
                            }
                        }), (BooleanExpression)Bindings.createBooleanBinding(() -> ShipmentsProductsExcludeAction.lambda$null$8((IntegerProperty)count), (Observable[])new Observable[]{count})).show((Node)source);
                    });
                }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading);
            }
        });
    }

    private static /* synthetic */ Boolean lambda$null$8(IntegerProperty count) throws Exception {
        return count.get() > 0;
    }

    private static /* synthetic */ void lambda$null$4(IntegerProperty count, Map datas, BooleanValueWidget removeEmptyShipmentWidget, ObservableValue observable, Object oldObject, Object newObject) {
        Boolean oldCasted = (Boolean)oldObject;
        Boolean newCasted = (Boolean)newObject;
        if (!oldCasted.booleanValue() && newCasted.booleanValue()) {
            count.set(count.get() + 1);
        } else if (oldCasted.booleanValue() && !newCasted.booleanValue()) {
            count.set(count.get() - 1);
        }
        if (count.get() == datas.size()) {
            removeEmptyShipmentWidget.getViewState().setReadonly(false);
            removeEmptyShipmentWidget.setValue(true);
        } else {
            removeEmptyShipmentWidget.getViewState().setReadonly(true);
            removeEmptyShipmentWidget.setValue(false);
        }
    }
}

