/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentsProductsIncludeDialogPanelController;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentsProductsIncludeDialogPanelProductsTableVM;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsIncludeTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsIncludeTaskResult;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;

public class ShipmentsProductsIncludeAction
implements RootEntityAction {
    public String getId() {
        return "shipments-products-include";
    }

    public double getWeight() {
        return 200.0;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.SHIPMENTS_PRODUCTS_INCLUDE;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        if (context.getMode() == EditingMode.CREATE || context.getMode() == EditingMode.VIEW || context.getData() == null) {
            return false;
        }
        EntityContainer shipmentContainer = context.getData().getContainer();
        ShipmentUIData supplement = (ShipmentUIData)context.getData().getSupplement();
        return ((Shipment)shipmentContainer.getEntity()).getCorrectionShipments().isEmpty() && ((Shipment)shipmentContainer.getEntity()).getPaymentItems().isEmpty() && supplement.getFinanceDocuments().stream().noneMatch(finDoc -> FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)finDoc.getType()));
    }

    public void execute(final Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            final EntityContainer shipmentContainer = context.getData().getContainer();
            if (shipmentContainer != null) {
                final Shipment shipment = (Shipment)shipmentContainer.getEntity();
                SimpleIntegerProperty count = new SimpleIntegerProperty();
                final ShipmentsProductsIncludeDialogPanelController controller = new ShipmentsProductsIncludeDialogPanelController(false);
                ((TableWidget)controller.getProducts().getView()).setOnRowsAction(event -> count.set(((TableWidget)controller.getProducts().getView()).getRowsCount()));
                ((TableWidget)controller.getProducts().getView()).setItemsProvider((MultiProvider)new MultiProvider<ShipmentsProductsIncludeDialogPanelProductsTableVM>(){

                    public ShipmentsProductsIncludeDialogPanelProductsTableVM createOne() {
                        return new ShipmentsProductsIncludeDialogPanelProductsTableVM();
                    }

                    public void createAny(Consumer<Collection<ShipmentsProductsIncludeDialogPanelProductsTableVM>> consumer) {
                        IndexListParameters parameters = new IndexListParameters();
                        parameters.setIndexType(CommonProductIndex.class);
                        ListParametersHelper.setColumns(parameters, CommonProductIndex.Property.productType.name(), CommonProductIndex.Property.systemNumbers.name(), CommonProductIndex.Property.status.name(), CommonProductIndex.Property.issueDate.name());
                        ListParametersHelper.setFilters(parameters, CommonProductIndex.Property.productType.name(), CommonProductIndex.Property.status.name());
                        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), (Object)shipment.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)shipment.getCustomer())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)shipment.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)shipment.getCustomer())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)shipment.getSupplier()), SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)shipment.getCustomer())})}));
                        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])FinanceDocumentsHelper.allowedProductStatusesShipment.stream().map(item -> SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)item)).toArray(SearchCriterion[]::new))));
                        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.fopComponentsAllUsed.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)CommonProductIndex.Property.fopComponentsAllUsed.name(), null)}));
                        parameters.getSearchCriterions().addAll(((TableWidget)controller.getProducts().getView()).getRowsData().stream().map(item -> SearchCriterion.ne((String)"navigationKey", (Object)item.getProduct().getNestedEntityUid())).collect(Collectors.toList()));
                        if (shipment.isCorrection()) {
                            parameters.getSearchCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                        } else {
                            parameters.getSearchCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                        }
                        parameters.getSortings().put(CommonProductIndex.Property.issueDate.name(), SortOrder.DESC);
                        IndexListPane<BookingFile, CommonProductIndex> productIndexListPane = new IndexListPane<BookingFile, CommonProductIndex>(new ObservableMutex(), parameters, SelectionMode.MULTIPLE, false){

                            protected void newConfigurationPopulated() {
                                super.newConfigurationPopulated();
                                this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
                            }
                        };
                        new Dialog().setTitle(Messages.shipmentsProductsIncludeSelectProducts).setBody((Node)productIndexListPane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Select, () -> this.lambda$createAny$3((IndexListPane)productIndexListPane, consumer), (BooleanExpression)Bindings.createBooleanBinding(() -> 1.lambda$createAny$4((IndexListPane)productIndexListPane), (Observable[])new Observable[]{productIndexListPane.selectionPresentProperty()})).show((Node)source);
                    }

                    private static /* synthetic */ Boolean lambda$createAny$4(IndexListPane productIndexListPane) throws Exception {
                        return productIndexListPane.selectionPresentProperty().get();
                    }

                    private /* synthetic */ void lambda$createAny$3(IndexListPane productIndexListPane, Consumer consumer) {
                        ArrayList<ShipmentsProductsIncludeDialogPanelProductsTableVM> values = new ArrayList<ShipmentsProductsIncludeDialogPanelProductsTableVM>();
                        for (CommonProductIndex index : productIndexListPane.getSelectedItems()) {
                            ShipmentsProductsIncludeDialogPanelProductsTableVM value = this.createOne();
                            value.setProduct(new NestedEntityReference(index.getSource(), index.getNavigationKey(), BaseProduct.class, null));
                            value.setProductType(index.getProductType());
                            value.setStatus(index.getStatus());
                            value.setSystemNumber(index.getSystemNumbers().stream().collect(Collectors.joining(", ")));
                            value.setIssueDate(DateUtils.asLocalDate((Date)index.getIssueDate()));
                            values.add(value);
                        }
                        consumer.accept(values);
                    }
                });
                controller.getMainParameters().setDate(DateUtils.asLocalDate((Date)shipment.getDate()));
                new Dialog().setTitle(Messages.shipmentsProductsInclude).setBody((Node)controller.getView()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.include, () -> Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                    protected String getTitle() {
                        return Messages.shipmentsProductsIncludeProcess;
                    }

                    protected String getTaskClassName() {
                        return "com.gridnine.xtrip.server.fx.async.entityactions.ShipmentsProductsIncludeAsyncTask";
                    }

                    protected Serializable getTaskParameters() {
                        ShipmentsProductsIncludeTaskParameters parameters = new ShipmentsProductsIncludeTaskParameters();
                        parameters.setDate(DateUtils.asDate((LocalDate)controller.getMainParameters().getDate()));
                        parameters.getProducts().clear();
                        parameters.getProducts().addAll(((TableWidget)controller.getProducts().getView()).getRowsData().stream().map(item -> item.getProduct()).collect(Collectors.toList()));
                        parameters.getShipments().clear();
                        parameters.getShipments().addAll(Collections.singleton(shipmentContainer.toReference()));
                        return parameters;
                    }

                    protected void onCompleted(Object object, List<Message> messages) {
                        ShipmentsProductsIncludeTaskResult result = (ShipmentsProductsIncludeTaskResult)object;
                        if (result.getChangeData() != null) {
                            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                        }
                        for (int i = 0; i < result.getDocuments().size(); ++i) {
                            RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                        }
                    }
                }), (BooleanExpression)Bindings.createBooleanBinding(() -> controller.getMainParameters().getDate() != null && count.get() > 0, (Observable[])new Observable[]{controller.getMainParameters().getView().getDateNode().valueProperty(), count})).show((Node)source);
            }
        });
    }
}

