/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.TransactionActionsDialogPanel;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.time.LocalDateTime;
import java.util.Date;

public class TransactionActions {
    public static void createTransaction(TransactionActionsDialogPanel panel, final TransactionsCallback executable) {
        final EntityReference client = (EntityReference)panel.getClientNode().valueProperty().get();
        final Money amount = (Money)panel.getAmountNode().valueProperty().get();
        final EntityReference agency = (EntityReference)panel.getAgencyNode().valueProperty().get();
        final PaymentType paymentType = (PaymentType)panel.getPaymentTypeNode().valueProperty().get();
        final ContractType contractType = (ContractType)panel.getContractNode().valueProperty().get();
        final Date date = DateUtils.asDate((LocalDateTime)((LocalDateTime)panel.getDateNode().valueProperty().get()));
        final BillingTransactionCategory category = (BillingTransactionCategory)panel.getCategoryNode().valueProperty().get();
        final EntityReference agent = (EntityReference)panel.getAgentNode().valueProperty().get();
        final BillingTransactionType transactionType = (BillingTransactionType)panel.getTypeNode().valueProperty().get();
        final EntityReference order = (EntityReference)panel.getOrderNode().valueProperty().get();
        final BillingTransactionStatus transactionStatus = (BillingTransactionStatus)panel.getStatusNode().valueProperty().get();
        final String description = panel.getDescriptionNode().getValue();
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Creating_transaction;
            }

            protected void execute() throws Exception {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                this.setProgress((byte)15, "");
                EntityContainer transactionContainer = new EntityContainer(BillingTransaction.class);
                transactionContainer.getVersionInfo().setDataSource("fx-add-transaction");
                ((BillingTransaction)transactionContainer.getEntity()).setClient(client);
                ((BillingTransaction)transactionContainer.getEntity()).setSum(amount);
                ((BillingTransaction)transactionContainer.getEntity()).setAgency(agency);
                ((BillingTransaction)transactionContainer.getEntity()).setPaymentType(paymentType);
                ((BillingTransaction)transactionContainer.getEntity()).setContractType(contractType);
                ((BillingTransaction)transactionContainer.getEntity()).setDate(date);
                ((BillingTransaction)transactionContainer.getEntity()).setCategory(category);
                ((BillingTransaction)transactionContainer.getEntity()).setAgent(agent);
                ((BillingTransaction)transactionContainer.getEntity()).setType(transactionType);
                ((BillingTransaction)transactionContainer.getEntity()).setEntity(order);
                ((BillingTransaction)transactionContainer.getEntity()).setStatus(transactionStatus);
                ((BillingTransaction)transactionContainer.getEntity()).setDescription(description);
                this.setProgress((byte)75, "");
                executable.setContainer(entityService.save(sic, transactionContainer, null, true));
                this.setProgress((byte)90, "");
                FxUtil.waitForFxThread((Executable)executable);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Transaction_Created, (Object[])new Object[0])});
                this.setProgress((byte)100, "");
            }
        });
    }

    public static void editTransaction(TransactionActionsDialogPanel panel, final EntityReference<BillingTransaction> source, final TransactionsCallback executable) {
        final EntityReference client = (EntityReference)panel.getClientNode().valueProperty().get();
        final Money amount = (Money)panel.getAmountNode().valueProperty().get();
        final EntityReference agency = (EntityReference)panel.getAgencyNode().valueProperty().get();
        final PaymentType paymentType = (PaymentType)panel.getPaymentTypeNode().valueProperty().get();
        final ContractType contractType = (ContractType)panel.getContractNode().valueProperty().get();
        final Date date = DateUtils.asDate((LocalDateTime)((LocalDateTime)panel.getDateNode().valueProperty().get()));
        final BillingTransactionCategory transactionCategory = (BillingTransactionCategory)panel.getCategoryNode().valueProperty().get();
        final EntityReference agent = (EntityReference)panel.getAgentNode().valueProperty().get();
        final BillingTransactionType transactionType = (BillingTransactionType)panel.getTypeNode().valueProperty().get();
        final EntityReference order = (EntityReference)panel.getOrderNode().valueProperty().get();
        final BillingTransactionStatus transactionStatus = (BillingTransactionStatus)panel.getStatusNode().valueProperty().get();
        final String description = panel.getDescriptionNode().getValue();
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Saving_transaction_changes;
            }

            protected void execute() throws Exception {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                this.setProgress((byte)15, "");
                EntityContainer transactionContainer = entityService.load(sic, source);
                this.setProgress((byte)25, "");
                transactionContainer.getVersionInfo().setDataSource("fx-edit-transaction");
                ((BillingTransaction)transactionContainer.getEntity()).setClient(client);
                ((BillingTransaction)transactionContainer.getEntity()).setSum(amount);
                ((BillingTransaction)transactionContainer.getEntity()).setAgency(agency);
                ((BillingTransaction)transactionContainer.getEntity()).setPaymentType(paymentType);
                ((BillingTransaction)transactionContainer.getEntity()).setContractType(contractType);
                ((BillingTransaction)transactionContainer.getEntity()).setDate(date);
                ((BillingTransaction)transactionContainer.getEntity()).setCategory(transactionCategory);
                ((BillingTransaction)transactionContainer.getEntity()).setAgent(agent);
                ((BillingTransaction)transactionContainer.getEntity()).setType(transactionType);
                ((BillingTransaction)transactionContainer.getEntity()).setEntity(order);
                ((BillingTransaction)transactionContainer.getEntity()).setStatus(transactionStatus);
                ((BillingTransaction)transactionContainer.getEntity()).setDescription(description);
                this.setProgress((byte)75, "");
                executable.setContainer(entityService.save(sic, transactionContainer, null, true));
                this.setProgress((byte)90, "");
                FxUtil.waitForFxThread((Executable)executable);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Data_is_saved, (Object[])new Object[0])});
                this.setProgress((byte)100, "");
            }
        });
    }

    public static abstract class TransactionsCallback
    implements Executable {
        protected EntityContainer<?> container;

        public void setContainer(EntityContainer<?> containerValue) {
            this.container = containerValue;
        }
    }
}

