/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.model.profile.TransactionActionsDialogPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.TransactionActions;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class TransactionAddListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public double getWeight() {
        return 23.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return BillingTransaction.class.getName().equals(ett.getId());
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        TransactionActionsDialogPanel panel = new TransactionActionsDialogPanel(false);
        Dialog dialog = new Dialog();
        panel.getPaymentTypeNode().valueProperty().set((Object)PaymentType.CASH);
        TransactionActions.TransactionsCallback callback = new TransactionActions.TransactionsCallback(){

            public void execute() throws Exception {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)TransactionAddListAction.this, new EntityModification(this.container.toReference(), EntityModification.ModificationType.DELETE)));
            }
        };
        dialog.setBody((Node)panel).setTitle(Messages.Adding_New_Transaction).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> TransactionActions.createTransaction(panel, callback)).show(context);
    }

    public String getId() {
        return "transaction-addlistaction";
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_BILLING_TRANSACTION.getId());
    }
}

