/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.profile.TransactionActionsDialogPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.TransactionActions;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class TransactionEditListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EDIT;
    }

    public double getWeight() {
        return 24.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return BillingTransaction.class.getName().equals(ett.getId());
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        if (context.getSelectedItems().size() > 0) {
            try {
                TransactionActionsDialogPanel panel = new TransactionActionsDialogPanel(false);
                EntityIndex entityIndex = (EntityIndex)context.getSelectedItems().get(0);
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer transactionContainer = entityService.load(sic, entityIndex.getSource());
                panel.getClientNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getClient());
                panel.getAmountNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getSum());
                panel.getAgencyNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getAgency());
                panel.getPaymentTypeNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getPaymentType());
                panel.getContractNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getContractType());
                panel.getDateNode().valueProperty().set((Object)DateUtils.asLocalDateTime((Date)((BillingTransaction)transactionContainer.getEntity()).getDate()));
                panel.getCategoryNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getCategory());
                panel.getAgentNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getAgent());
                panel.getTypeNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getType());
                panel.getOrderNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getEntity());
                panel.getStatusNode().valueProperty().set((Object)((BillingTransaction)transactionContainer.getEntity()).getStatus());
                panel.getDescriptionNode().setValue(((BillingTransaction)transactionContainer.getEntity()).getDescription());
                TransactionActions.TransactionsCallback callback = new TransactionActions.TransactionsCallback(){

                    public void execute() throws Exception {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)TransactionEditListAction.this, new EntityModification(this.container.toReference(), EntityModification.ModificationType.CHANGE)));
                    }
                };
                new Dialog().setTitle(Messages.Editing_Transaction).setBody((Node)panel).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> TransactionActions.editTransaction(panel, (EntityReference<BillingTransaction>)entityIndex.getSource(), callback)).show(context);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        } else {
            Dialog.info((Node)source, (String)Messages.Before_editing_select_transaction);
        }
    }

    public String getId() {
        return "transaction-editlistaction";
    }
}

