/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.control.Control;

public class TrashBinItemRestoreAction
implements RootEntityAction {
    public String getId() {
        return "trash-bin-item-restore";
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.RECOVER;
    }

    public double getWeight() {
        return 11.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && TrashBinItem.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityReference ref = context.getData().getContainer().toReference();
        Notifications.get().submitTask(() -> {
            EntityContainer restored = ((ModelService)RpcServiceManager.get().getService(ModelService.class)).restore(ServiceInvocationContext.get(), ref);
            RootEntityEditingService.navigateTo((EntityReference)restored.toReference());
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(ref, EntityModification.ModificationType.DELETE)));
        }, context.getMutex());
    }
}

