/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.actions.TrashBinItemRestoreTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class TrashBinItemRestoreListAction
implements IndexListAction {
    public String getId() {
        return "trash-bin-item-restore-list";
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.RECOVER;
    }

    public double getWeight() {
        return 0.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return TrashBinItemIndex.class.isAssignableFrom(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems().stream().collect(Collectors.toList());
        Dialog.confirm((Node)source, (String)Messages.TrashBin_RestoreConfirmation, null, (String)Messages.TrashBin_RestoreAction, () -> Notifications.get().enqueueAsyncTask((ClientTask)new TrashBinItemRestoreTask(selectedItems.stream().map(EntityIndex::getSource).collect(Collectors.toList()))), null);
    }
}

