/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class TrashBinItemRestoreTask
extends ClientTask {
    private final List<EntityReference<TrashBinItem>> items;

    TrashBinItemRestoreTask(List<EntityReference<TrashBinItem>> itemsToRestore) {
        this.items = new ArrayList<EntityReference<TrashBinItem>>(itemsToRestore);
    }

    protected String getTitle() {
        return Messages.TrashBin_TaskTitle;
    }

    protected void execute() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ModelService service = (ModelService)RpcServiceManager.get().getService(ModelService.class);
        float progress = 0.0f;
        float step = 100 / this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            EntityReference<TrashBinItem> item2 = this.items.get(i);
            service.restore(sic, item2);
            this.setProgress((byte)(progress += step), "");
        }
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.items.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
    }
}

