/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Referenceable;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;

public class ViewEntityAction
implements IndexListAction {
    static void openByUID(Region anchor, Class<?> entityType, boolean forEditing) {
        RootEntityHandler entityHandler = RootEntityHandler.forEntityClass(entityType);
        if (entityHandler == null || !entityHandler.isAvaibleInConfiguration()) {
            StandardNotifications nf = forEditing ? StandardNotifications.EDITOR_NOT_SUPPORTED : StandardNotifications.VIEWER_NOT_SUPPORTED;
            nf.show(entityType.getName());
            return;
        }
        final TextFieldWidget widget = new TextFieldWidget(false);
        widget.setStyle("-fx-pref-width:30em");
        new LightDialog().setTitle(Messages.getEnter_UID(RootEntityHandler.format((RootEntityHandler)entityHandler))).setBody((Node)widget).setActionAvailability((BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{widget.valueProperty()});
            }

            protected boolean computeValue() {
                return !TextUtil.isBlank((String)widget.getValue());
            }
        }).setActionCaption(forEditing ? Messages.Edit : Messages.Look).setActionHandler(() -> {
            try {
                RootEntityEditingService.get().open(new EntityReference(widget.getValue(), entityHandler.getEntityClass(), null), forEditing);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }).show(anchor);
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.VIEW;
    }

    public String getId() {
        return "entity-view";
    }

    public double getWeight() {
        return 0.5;
    }

    public KeyBindingAction getKeyBindingAction() {
        return StandardKeyBindingActions.VIEW;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        ArrayList<EntityReference> unsupported = new ArrayList<EntityReference>();
        boolean bgLoad = false;
        for (EntityIndex idx : selectedItems) {
            try {
                EntityReference sourceRef;
                EntityReference entityReference = sourceRef = idx instanceof Referenceable ? ((Referenceable)idx).getRef() : idx.getSource();
                if (RootEntityHandler.forEntityClass((Class)sourceRef.getType()) == null) {
                    unsupported.add(sourceRef);
                    continue;
                }
                String navigationKey = idx.getNavigationKey();
                if (TextUtil.isBlank((String)navigationKey)) {
                    RootEntityEditingService.get().open(sourceRef, false, null, bgLoad);
                } else {
                    RootEntityEditingService.get().open(sourceRef, false, rep -> FxUtil.submitToFxThread(() -> ViewWalker.navigateTo((Node)rep.getEditor(), (String)navigationKey)), bgLoad);
                }
                bgLoad = true;
            }
            catch (NullPointerException exception) {
                ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
                stackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"SelectedItems List", (String)selectedItems.toString()));
                stackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"Item position", (String)String.valueOf(selectedItems.indexOf(idx))));
                stackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"ItemUid", (String)idx.getUid()));
                stackTraceElements.forEach(incident -> {
                    NullPointerException cfr_ignored_0 = (NullPointerException)IncidentsHelper.addStackTraceElement((Throwable)exception, (StackTraceElement[])new StackTraceElement[]{incident});
                });
                throw exception;
            }
        }
        if (!unsupported.isEmpty()) {
            if (alt) {
                for (EntityReference ref : unsupported) {
                    EntityEditorHelper.open(ref, null);
                }
                return;
            }
            if (selectedItems.size() == unsupported.size()) {
                Notifications.get().showFlashNotification(Messages.Document_viewing_is_not_supported, null);
            } else {
                Notifications.get().showFlashNotification(Messages.Some_Document_viewing_is_not_supported, null);
            }
        }
    }
}

