/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.copy;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.copy.CopyEntityActionHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.control.Control;

public class CopyEntityListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.COPY;
    }

    public double getWeight() {
        return 21.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(context.getIndexType().getName());
        return indexType != null && CopyEntityActionHandler.forEntityClass(indexType.getEntityId()) != null;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        EntityIndex item = (EntityIndex)context.getSelectedItems().get(0);
        if (item == null) {
            return;
        }
        EntityReference ref = item.getSource();
        CopyEntityActionHandler copyHandler = CopyEntityActionHandler.forEntityClass(ref.getType());
        RootEntityHandler entityHandler = RootEntityHandler.forEntityClass((Class)ref.getType());
        if (copyHandler == null || entityHandler == null || !entityHandler.isAvaibleInConfiguration()) {
            StandardNotifications.EDITOR_NOT_SUPPORTED.show(ref.getType().getName());
            return;
        }
        Notifications.get().submitTask(() -> {
            Class supplementClass = entityHandler.getSupplementClass();
            DataTransferPackage data = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ref, Void.class.isAssignableFrom(supplementClass) ? null : supplementClass);
            if (data == null || data.getContainer() == null) {
                return;
            }
            FxUtil.submitToFxThread(() -> {
                try {
                    RootEntityActivityHandler.editNew(copyHandler.createCopy(data));
                }
                catch (Exception ex) {
                    ErrorHandler.handle((Throwable)ex);
                }
            });
        }, Messages.Loading_document_for_create_a_copy);
    }

    public String getId() {
        return "entity-copyInList";
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return new AclQuery(StandardRestrictionResourceOperations.COPY.getId(), ett.getId());
    }
}

