/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.erasure;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public class TaskStatusAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 20.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && context.getEntityHandler().getEntityClass().equals(ErasureRequest.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return ((ErasureRequest)context.getData().getContainer().getEntity()).getActiveTask() != null;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        ErasureRequest request = (ErasureRequest)context.getData().getContainer().getEntity();
        if (request.getActiveTask() == null) {
            return;
        }
        String taskUid = request.getActiveTask().getUid();
        Notifications.get().submitTask(() -> this.loadTask(context, taskUid), Messages.Loading_task_data);
    }

    private void loadTask(RootEntityPane<?, ?> context, String taskUid) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseAsset.Property.uid.name(), (Object)taskUid));
        LongRunningTaskInfo taskInfo = (LongRunningTaskInfo)((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), LongRunningTaskInfo.class, query).getData().get(0);
        FxUtil.submitToFxThread(() -> this.showTask(context, taskInfo));
    }

    private void showTask(RootEntityPane<?, ?> context, LongRunningTaskInfo taskInfo) {
        if (taskInfo == null) {
            Notifications.get().showFlashNotification(Messages.Task_not_found, null);
            return;
        }
        LrtHandler<?> handler = LrtHandler.forTaskClassName(taskInfo.getTaskClassName());
        RichTextFlow rtf = new RichTextFlow(TextHandler.SIMPLE_HTML, this.buildDetails(taskInfo));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.getTask(handler == null ? "???" : handler.getName())).setBody((Node)rtf).setExpandToParent(true).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.AUXILARY, Messages.Copy, () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, rtf.toPlainText()))).show(context);
    }

    private String buildDetails(LongRunningTaskInfo taskInfo) {
        DateFormat df = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        L10nResourcesManager rm = LocaleManager.get().getL10nResourceManager();
        StringBuilder text = new StringBuilder("<html>");
        text.append("<b>" + Messages.Description + ":</b> " + taskInfo.getDescription());
        if (taskInfo.getCreated() != null) {
            text.append("<br><b>" + Messages.Created + "</b> " + df.format(taskInfo.getCreated()) + ' ' + taskInfo.getCreatedBy());
        }
        if (taskInfo.getStartDate() != null) {
            text.append("<br><b>" + Messages.Start_date + ":</b> " + df.format(taskInfo.getStartDate()));
        }
        if (taskInfo.getEndDate() != null) {
            text.append("<br><b>" + Messages.Finish_date + ":</b> " + df.format(taskInfo.getEndDate()));
        }
        if (!TextUtil.isBlank((String)taskInfo.getInstance())) {
            text.append("<br><b>" + Messages.Node + ":</b> " + taskInfo.getInstance());
        }
        if (taskInfo.getState() != null) {
            text.append("<br><b>" + Messages.Status + ":</b> " + taskInfo.getState());
        }
        if (taskInfo.isIndefinite()) {
            text.append("<br><b>" + Messages.Progress + ":</b> " + Integer.toString(taskInfo.getProgress()) + "%");
        }
        text.append("<br><b>" + Messages.Messages + "</b>");
        for (LongRunningTaskInfo.Event event : taskInfo.getEvents().get()) {
            text.append("<br><b>" + (event.getDate() != null ? df.format(event.getDate()) : "???") + " " + event.getDescription().getType() + ": </b>" + rm.getMessage(event.getDescription().getMessage()));
            if (TextUtil.isBlank((String)event.getDescription().getDetails())) continue;
            text.append("<br><b>" + Messages.Extra_info + ":</b><br>").append(event.getDescription().getDetails()).append("<br>");
        }
        return text.toString();
    }

    public String getId() {
        return "erasure-task-status-action";
    }
}

