/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

final class ExcelExporter {
    ExcelExporter() {
    }

    static Map<String, HSSFCellStyle> collectStyles(HSSFWorkbook workBook, List<TableColumnSettings> columnSettings) {
        HSSFDataFormat format = null;
        HSSFCellStyle doubleStyle = null;
        HSSFCellStyle dateStyle = null;
        HSSFCellStyle dateTimeStyle = null;
        HashMap<String, HSSFCellStyle> result = new HashMap<String, HSSFCellStyle>();
        for (TableColumnSettings colSett : columnSettings) {
            if (BigDecimal.class.getName().equals(colSett.getType())) {
                if (doubleStyle == null) {
                    if (format == null) {
                        format = workBook.getCreationHelper().createDataFormat();
                    }
                    doubleStyle = workBook.createCellStyle();
                    doubleStyle.setDataFormat(format.getFormat("#\u00a0##0.00"));
                }
                result.put(colSett.getId(), doubleStyle);
            }
            if (!Date.class.getName().equals(colSett.getType())) continue;
            if (colSett.getRenderer() == StandardRenderers.DATE_TIME) {
                if (dateTimeStyle == null) {
                    if (format == null) {
                        format = workBook.getCreationHelper().createDataFormat();
                    }
                    dateTimeStyle = workBook.createCellStyle();
                    dateTimeStyle.setDataFormat(format.getFormat("dd/mm/yy hh:mm"));
                }
                result.put(colSett.getId(), dateTimeStyle);
                continue;
            }
            if (dateStyle == null) {
                if (format == null) {
                    format = workBook.getCreationHelper().createDataFormat();
                }
                dateStyle = workBook.createCellStyle();
                dateStyle.setDataFormat(format.getFormat("dd/mm/yy"));
            }
            result.put(colSett.getId(), dateStyle);
        }
        return result;
    }

    static void createHeader(List<TableColumnSettings> columnSettings, HSSFSheet sheet, HSSFWorkbook wb) {
        HSSFRow headerRow = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        style.setFont(font);
        AtomicInteger i = new AtomicInteger(0);
        columnSettings.forEach(property -> {
            HSSFCell cell = headerRow.createCell(i.getAndIncrement());
            cell.setCellStyle(style);
            cell.setCellValue((RichTextString)new HSSFRichTextString(property.getDisplayName()));
        });
    }

    static void createRow(List<TableColumnSettings> columnSettings, Function<String, Object> valueSupplier, HSSFSheet sheet, Map<String, HSSFCellStyle> cellStyles) {
        AtomicInteger i = new AtomicInteger(0);
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        columnSettings.forEach(property -> ExcelExporter.setCellValue(row.createCell(i.getAndIncrement()), valueSupplier.apply(property.getId()), property, (HSSFCellStyle)cellStyles.get(property.getId())));
    }

    static void autosize(HSSFWorkbook workBook) {
        for (Sheet sheet : workBook) {
            Iterator iterator = sheet.iterator();
            if (!iterator.hasNext()) continue;
            Row row = (Row)iterator.next();
            for (Cell cell : row) {
                sheet.autoSizeColumn(cell.getColumnIndex());
            }
        }
    }

    private static void setCellValue(HSSFCell cell, Object value, TableColumnSettings field, HSSFCellStyle cellStyle) {
        if (value == null) {
            cell.setCellValue((RichTextString)((HSSFRichTextString)null));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).setScale(2, RoundingMode.HALF_UP).doubleValue());
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(ExcelExporter.value2str(value)));
        }
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
    }

    private static String value2str(Object value) {
        if (value instanceof Iterable) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : (Iterable)value) {
                String val = ExcelExporter.value2str(obj);
                if (TextUtil.isBlank((String)val)) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(val);
            }
            return buf.toString();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            return new DecimalFormat("#0.00").format(value);
        }
        return value.toString();
    }
}

