/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportEntityClientTaskHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;

public class ExportEntityHelper {
    private static final Map<String, String> PATHS = new HashMap<String, String>();
    private static final String FORMAT_ZIP_FOR_MOM = Messages.ZIP_for_MOM;
    private static final String FORMAT_XLS = "XLS";
    private static final String FORMAT_CSV = "CSV";
    private static final String FORMAT_XML_FOR_EXTERNAL_SYSTEMS = Messages.XML_for_external_systems;
    private static final String ORG_CONFIGURATION_FILTER_FILE_PROPERTY_NAME = "export.organization.xml.filter.file";
    private static final String ORG_CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME = "export.organization.xml.filter.exclusive";
    private static final String BF_CONFIGURATION_FILTER_FILE_PROPERTY_NAME = "export.booking.xml.filter.file";
    private static final String BF_CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME = "export.booking.xml.filter.exclusive";

    public static void showExportEntityDialog(Node owner, EntityContainer<?> ctr) {
        String entityName = ctr.getEntity().getClass().getSimpleName().toLowerCase();
        boolean xmlAvailable = ExportEntityHelper.checkEntityForXML(entityName);
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> {
            if (xmlAvailable) {
                return Arrays.asList(ExportEntityHelper.zipExtensionFilter(), ExportEntityHelper.xmlExtensionFilter());
            }
            return Collections.singletonList(ExportEntityHelper.zipExtensionFilter());
        });
        fileChooserWidget.setDefaultFilePathBuilder(ExportEntityHelper.getDefaultPathString(ctr.getEntityType()));
        ExportEntityHelper.updateFileChooserWidgetFromLastFile(fileChooserWidget, xmlAvailable, false);
        RadioBoxWidget<String> fileFormatWidget = ExportEntityHelper.getFileFormatWidgetForEntity(entityName, fileChooserWidget.fileExtensionProperty());
        fileChooserWidget.getFiles().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasUpdated()) continue;
                if (fileChooserWidget.getFileExtension().equals(".xml")) {
                    if (xmlAvailable) {
                        fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
                        continue;
                    }
                    fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
                    fileChooserWidget.setFileExtension(".zip");
                    continue;
                }
                if (!fileChooserWidget.getFileExtension().equals(".zip")) continue;
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            }
        });
        fileFormatWidget.valueProperty().addListener(str -> {
            if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS)) {
                if (xmlAvailable) {
                    fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.xmlExtensionFilter()));
                } else {
                    fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.zipExtensionFilter()));
                }
            } else if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_ZIP_FOR_MOM)) {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.zipExtensionFilter()));
            }
        });
        new Dialog().setTitle(Messages.Export_Parameters).setBody((Node)ExportEntityHelper.buildContainerWithoutObjectSelection(fileChooserWidget, fileFormatWidget)).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Export, () -> {
            if (fileChooserWidget.getFiles().isEmpty()) {
                Dialog.info((Node)owner, (String)Messages.Path_is_noy_specified);
                return;
            }
            File exportFile = (File)fileChooserWidget.getFiles().get(0);
            if (".xml".equals(fileChooserWidget.getFileExtension())) {
                List filters = XMLFilterHelper.getFilters();
                if (ctr.getEntity() instanceof Organization) {
                    boolean filterExclusive;
                    String filterFile = ClientSettings.get().getProperty(ORG_CONFIGURATION_FILTER_FILE_PROPERTY_NAME);
                    String filterExclusiveString = ClientSettings.get().getProperty(ORG_CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME);
                    boolean bl = filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.equalsIgnoreCase("false");
                    if (!TextUtil.isBlank((String)filterFile)) {
                        try {
                            if (filterExclusive) {
                                filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                            } else {
                                filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                            }
                        }
                        catch (IOException e) {
                            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.ExportOrganization_fileNotFound, (Throwable)e, (Object[])new Object[0]));
                        }
                    }
                }
                ExportEntityClientTaskHelper.exportXML(exportFile, ctr.toReference(), filters);
            } else if (".zip".equals(fileChooserWidget.getFileExtension())) {
                ExportEntityClientTaskHelper.exportZIP(exportFile, ctr.toReference());
            } else {
                Dialog.info((Node)owner, (String)Messages.Unsupported_file_type);
            }
            ClientSettings.get().setLastExportFile(exportFile);
            ClientSettings.get().save();
        }).show(owner);
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> void showExportEntitiesDialog(Node owner, Class<I> indexType, List<I> items, SearchQuery query, List<TableColumnSettings> columnSettings) {
        String entityName = MetaRegistryHelper.getEntityTypeForIndex((String)indexType.getName()).getId().toLowerCase();
        int p = entityName.lastIndexOf(46);
        if (p > 0 && p < entityName.length() - 1) {
            entityName = entityName.substring(p + 1);
        }
        boolean xmlAvailable = ExportEntityHelper.checkEntityForXML(entityName);
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> {
            if (xmlAvailable) {
                return Arrays.asList(ExportEntityHelper.zipExtensionFilter(), ExportEntityHelper.xmlExtensionFilter(), ExportEntityHelper.xlsExtensionFilter(), ExportEntityHelper.csvExtensionFilter());
            }
            return Arrays.asList(ExportEntityHelper.zipExtensionFilter(), ExportEntityHelper.xlsExtensionFilter(), ExportEntityHelper.csvExtensionFilter());
        });
        fileChooserWidget.setDefaultFilePathBuilder(ExportEntityHelper.getDefaultPathString(entityName));
        ExportEntityHelper.updateFileChooserWidgetFromLastFile(fileChooserWidget, xmlAvailable, true);
        RadioBoxWidget<String> fileFormatWidget = ExportEntityHelper.getFileFormatWidget(entityName, fileChooserWidget.fileExtensionProperty(), false);
        fileChooserWidget.getFiles().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasUpdated()) continue;
                String ext = fileChooserWidget.getFileExtension();
                if (ext.equals(".xml")) {
                    if (xmlAvailable) {
                        fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
                        continue;
                    }
                    fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
                    fileChooserWidget.setFileExtension(".xls");
                    continue;
                }
                if (ext.equals(".xls")) {
                    fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
                    continue;
                }
                if (ext.equals(".csv")) {
                    fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
                    continue;
                }
                if (!ext.equals(".zip")) continue;
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            }
        });
        fileFormatWidget.valueProperty().addListener(str -> {
            if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS)) {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.xmlExtensionFilter()));
            } else if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_XLS)) {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.xlsExtensionFilter()));
            } else if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_CSV)) {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.csvExtensionFilter()));
            } else if (((String)fileFormatWidget.valueProperty().get()).equals(FORMAT_ZIP_FOR_MOM)) {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.zipExtensionFilter()));
            }
        });
        RadioBoxWidget<String> objectSelectionWidget = ExportEntityHelper.getObjectSelectionWidget(items.size(), true);
        new Dialog().setTitle(Messages.Export_Parameters).setExpandToParent(true).setBody((Node)ExportEntityHelper.buildContainer(fileChooserWidget, fileFormatWidget, objectSelectionWidget)).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.To_Export, () -> {
            block21: {
                try {
                    if (fileChooserWidget.getFiles().isEmpty()) {
                        Dialog.info((Node)owner, (String)Messages.No_file_specified);
                        break block21;
                    }
                    ClientSettings.get().setLastExportFile((File)fileChooserWidget.getFiles().get(0));
                    ClientSettings.get().save();
                    List itemsList = items.size() > 0 && ((String)objectSelectionWidget.getValue()).equals(Messages.Only_selected_objects) ? items : Collections.emptyList();
                    switch (fileChooserWidget.getFileExtension()) {
                        case ".xml": {
                            List filters = XMLFilterHelper.getFilters();
                            if (indexType.equals(OrganizationIndex.class)) {
                                boolean filterExclusive;
                                String filterFile = ClientSettings.get().getProperty(ORG_CONFIGURATION_FILTER_FILE_PROPERTY_NAME);
                                String filterExclusiveString = ClientSettings.get().getProperty(ORG_CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME);
                                boolean bl = filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.equalsIgnoreCase("false");
                                if (!TextUtil.isBlank((String)filterFile)) {
                                    try {
                                        if (filterExclusive) {
                                            filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                                        } else {
                                            filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                                        }
                                    }
                                    catch (IOException e) {
                                        ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.ExportOrganization_fileNotFound, (Throwable)e, (Object[])new Object[0]));
                                    }
                                }
                            }
                            ExportEntityClientTaskHelper.exportXML((File)fileChooserWidget.getFiles().get(0), indexType, query, itemsList, filters);
                            break;
                        }
                        case ".xls": {
                            ExportEntityClientTaskHelper.exportXLS((File)fileChooserWidget.getFiles().get(0), indexType, columnSettings, query, itemsList);
                            break;
                        }
                        case ".csv": {
                            ExportEntityClientTaskHelper.exportCSV((File)fileChooserWidget.getFiles().get(0), indexType, columnSettings, query, itemsList);
                            break;
                        }
                        case ".zip": {
                            ExportEntityClientTaskHelper.exportZIP((File)fileChooserWidget.getFiles().get(0), itemsList, indexType, query);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorHandler.handle((Throwable)ex);
                }
            }
        }).show(owner);
    }

    public static <I extends EntityIndex<BookingFile>> void showExportBookingsDialog(Node owner, Class<I> indexType, List<I> items, SearchQuery query, List<TableColumnSettings> columnSettings) {
        CheckBoxWidget extraParametersCheckBox = ExportEntityHelper.getExtraParametersCheckBox();
        DateValueWidget startDate = new DateValueWidget(false);
        DateValueWidget endDate = new DateValueWidget(false);
        EntityBoxWidget agency = new EntityBoxWidget(Organization.class, false);
        agency.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        EntityBoxWidget subAgency = new EntityBoxWidget(Organization.class, false);
        subAgency.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        EntityBoxWidget salesPoint = new EntityBoxWidget(SalesPoint.class, false);
        salesPoint.setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
        EntityBoxWidget client = new EntityBoxWidget(Organization.class, false);
        client.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
        CardsContainer extraParametersContainer = ExportEntityHelper.getExtraParametersContainer(extraParametersCheckBox, startDate, endDate, (EntityBoxWidget<Organization>)agency, (EntityBoxWidget<Organization>)subAgency, (EntityBoxWidget<SalesPoint>)salesPoint, (EntityBoxWidget<Organization>)client);
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Export_files_MOM, new String[]{"*.xml", "*.zip", "*.xls", "*.csv"})));
        fileChooserWidget.setDefaultFilePathBuilder(ExportEntityHelper.getDefaultPathString(BookingFile.class));
        File file = ClientSettings.get().getLastExportFile();
        if (file != null) {
            fileChooserWidget.getFiles().add((Object)file);
            String path = ((File)fileChooserWidget.getFiles().get(0)).getPath();
            String extension = FilenameUtils.getExtension((String)path);
            if (TextUtil.nonBlank((String)extension)) {
                fileChooserWidget.setFileExtension('.' + extension);
            }
        }
        RadioBoxWidget<String> fileFormatWidget = ExportEntityHelper.getFileFormatWidget(BookingFile.class.getSimpleName().toLowerCase(), fileChooserWidget.fileExtensionProperty(), extraParametersCheckBox, extraParametersContainer);
        fileChooserWidget.getFiles().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasUpdated()) continue;
                String ext = fileChooserWidget.getFileExtension();
                if (ext.equals(".xml")) {
                    fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
                    continue;
                }
                if (ext.equals(".xls")) {
                    fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
                    continue;
                }
                if (ext.equals(".csv")) {
                    fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
                    continue;
                }
                if (!ext.equals(".zip")) continue;
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            }
        });
        RadioBoxWidget<String> objectSelectionWidget = ExportEntityHelper.getObjectSelectionWidget(items.size(), true);
        new Dialog().setTitle(Messages.Export_Parameters).setBody((Node)ExportEntityHelper.buildContainer(fileChooserWidget, fileFormatWidget, objectSelectionWidget, extraParametersCheckBox, extraParametersContainer)).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.To_Export, () -> {
            block21: {
                try {
                    if (fileChooserWidget.getFiles().isEmpty()) {
                        Dialog.info((Node)owner, (String)Messages.No_file_specified);
                        break block21;
                    }
                    ClientSettings.get().setLastExportFile((File)fileChooserWidget.getFiles().get(0));
                    ClientSettings.get().save();
                    boolean isSelectedExport = items.size() > 0 && ((String)objectSelectionWidget.getValue()).equals(Messages.Only_selected_objects);
                    switch (fileChooserWidget.getFileExtension()) {
                        case ".xml": {
                            boolean filterExclusive;
                            List filters = XMLFilterHelper.getFilters();
                            String filterFile = ClientSettings.get().getProperty(BF_CONFIGURATION_FILTER_FILE_PROPERTY_NAME);
                            String filterExclusiveString = ClientSettings.get().getProperty(BF_CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME);
                            boolean bl = filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.equalsIgnoreCase("false");
                            if (!TextUtil.isBlank((String)filterFile)) {
                                try {
                                    if (filterExclusive) {
                                        filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                                    } else {
                                        filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                                    }
                                }
                                catch (IOException e) {
                                    ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.ExportBookingFile_fileNotFound, (Throwable)e, (Object[])new Object[0]));
                                }
                            }
                            if (extraParametersCheckBox.selectedProperty().get() && !extraParametersCheckBox.isDisabled()) {
                                ExportEntityClientTaskHelper.exportXML((File)fileChooserWidget.getFiles().get(0), DateUtils.asDate((LocalDate)((LocalDate)startDate.valueProperty().get())), DateUtils.asDate((LocalDate)((LocalDate)endDate.valueProperty().get())), (EntityReference<Organization>)((EntityReference)agency.valueProperty().get()), (EntityReference<Organization>)((EntityReference)subAgency.valueProperty().get()), (EntityReference<SalesPoint>)((EntityReference)salesPoint.valueProperty().get()), (EntityReference<Organization>)((EntityReference)client.valueProperty().get()), filters);
                                break;
                            }
                            ExportEntityClientTaskHelper.exportXML((File)fileChooserWidget.getFiles().get(0), indexType, query, isSelectedExport ? items : Collections.emptyList(), filters);
                            break;
                        }
                        case ".xls": {
                            ExportEntityClientTaskHelper.exportXLS((File)fileChooserWidget.getFiles().get(0), indexType, columnSettings, query, isSelectedExport ? items : Collections.emptyList());
                            break;
                        }
                        case ".csv": {
                            ExportEntityClientTaskHelper.exportCSV((File)fileChooserWidget.getFiles().get(0), indexType, columnSettings, query, isSelectedExport ? items : Collections.emptyList());
                            break;
                        }
                        case ".zip": {
                            ExportEntityClientTaskHelper.exportZIP((File)fileChooserWidget.getFiles().get(0), isSelectedExport ? items : Collections.emptyList(), indexType, query);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorHandler.handle((Throwable)ex);
                }
            }
        }).show(owner);
    }

    private static boolean checkEntityForXML(String className) {
        return ExportEntityHelper.getPaths().containsKey(className);
    }

    private static Map<String, String> getPaths() {
        return Collections.unmodifiableMap(PATHS);
    }

    private static RadioBoxWidget<String> getFileFormatWidget(String entityName, StringProperty fileExtension, boolean forEditForm) {
        RadioBoxWidget fileFormatWidget = new RadioBoxWidget(false);
        fileFormatWidget.setItemsSupplier(() -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            list.add(FORMAT_XLS);
            list.add(FORMAT_CSV);
            list.add(FORMAT_ZIP_FOR_MOM);
            return list;
        });
        fileFormatWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS)) {
                fileExtension.set((Object)".xml");
            } else if (newValue.equals(FORMAT_XLS)) {
                fileExtension.set((Object)".xls");
            } else if (newValue.equals(FORMAT_CSV)) {
                fileExtension.set((Object)".csv");
            } else if (newValue.equals(FORMAT_ZIP_FOR_MOM)) {
                fileExtension.set((Object)".zip");
            }
        });
        if (ExportEntityHelper.checkEntityForXML(entityName)) {
            if (fileExtension.get() == null || ((String)fileExtension.get()).equals(".zip")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
                fileExtension.set((Object)".zip");
            } else if (((String)fileExtension.get()).equals(".xml")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            } else if (((String)fileExtension.get()).equals(".xls")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
            } else if (((String)fileExtension.get()).equals(".csv")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
            }
        } else {
            fileFormatWidget.setDisabledItemChecker(value -> value.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS));
            if (fileExtension.get() == null || ((String)fileExtension.get()).equals(".xml") || ((String)fileExtension.get()).equals(".xls")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
                fileExtension.set((Object)".xls");
            } else if (((String)fileExtension.get()).equals(".csv")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
            } else if (((String)fileExtension.get()).equals(".zip")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            }
        }
        if (forEditForm) {
            fileFormatWidget.setDisabledItemChecker(value -> value.equals(FORMAT_XLS) || value.equals(FORMAT_CSV));
        }
        return fileFormatWidget;
    }

    private static RadioBoxWidget<String> getFileFormatWidgetForEntity(String entityName, StringProperty fileExtension) {
        RadioBoxWidget fileFormatWidget = new RadioBoxWidget(false);
        fileFormatWidget.setItemsSupplier(() -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            list.add(FORMAT_ZIP_FOR_MOM);
            return list;
        });
        fileFormatWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS)) {
                fileExtension.set((Object)".xml");
            } else if (newValue.equals(FORMAT_ZIP_FOR_MOM)) {
                fileExtension.set((Object)".zip");
            }
        });
        if (ExportEntityHelper.checkEntityForXML(entityName)) {
            if (fileExtension.get() == null || !((String)fileExtension.get()).equals(".xml")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
                fileExtension.set((Object)".zip");
            } else if (((String)fileExtension.get()).equals(".xml")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            }
        } else {
            fileFormatWidget.setDisabledItemChecker(value -> value.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS));
            fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            fileExtension.set((Object)".zip");
        }
        return fileFormatWidget;
    }

    private static RadioBoxWidget<String> getFileFormatWidget(String entityName, StringProperty fileExtension, CheckBoxWidget extraParametersCheckBox, CardsContainer extraParametersContainer) {
        RadioBoxWidget fileFormatWidget = new RadioBoxWidget(false);
        fileFormatWidget.setItemsSupplier(() -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            list.add(FORMAT_XLS);
            list.add(FORMAT_CSV);
            list.add(FORMAT_ZIP_FOR_MOM);
            return list;
        });
        fileFormatWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS)) {
                extraParametersCheckBox.setDisable(false);
                extraParametersContainer.setDisable(!extraParametersCheckBox.isSelected());
                fileExtension.set((Object)".xml");
            } else if (newValue.equals(FORMAT_XLS)) {
                extraParametersCheckBox.setDisable(true);
                extraParametersContainer.setDisable(true);
                fileExtension.set((Object)".xls");
            } else if (newValue.equals(FORMAT_CSV)) {
                extraParametersCheckBox.setDisable(true);
                extraParametersContainer.setDisable(true);
                fileExtension.set((Object)".csv");
            } else if (newValue.equals(FORMAT_ZIP_FOR_MOM)) {
                extraParametersCheckBox.setDisable(true);
                extraParametersContainer.setDisable(true);
                fileExtension.set((Object)".zip");
            }
        });
        if (ExportEntityHelper.checkEntityForXML(entityName)) {
            if (fileExtension.get() == null || ((String)fileExtension.get()).equals(".zip")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
                fileExtension.set((Object)".zip");
            } else if (((String)fileExtension.get()).equals(".xml")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XML_FOR_EXTERNAL_SYSTEMS);
            } else if (((String)fileExtension.get()).equals(".xls")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
            } else if (((String)fileExtension.get()).equals(".csv")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
            }
        } else {
            fileFormatWidget.setDisabledItemChecker(value -> value.equals(FORMAT_XML_FOR_EXTERNAL_SYSTEMS));
            if (fileExtension.get() == null || ((String)fileExtension.get()).equals(".xml") || ((String)fileExtension.get()).equals(".xls")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_XLS);
                fileExtension.set((Object)".xls");
            } else if (((String)fileExtension.get()).equals(".csv")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_CSV);
            } else if (((String)fileExtension.get()).equals(".zip")) {
                fileFormatWidget.valueProperty().set((Object)FORMAT_ZIP_FOR_MOM);
            }
        }
        return fileFormatWidget;
    }

    private static String getDefaultPathString(String entityName) {
        StringBuilder builder = new StringBuilder();
        builder.append(Environment.getDataFolder());
        if (ExportEntityHelper.checkEntityForXML(entityName)) {
            builder.append(ExportEntityHelper.getPaths().get(entityName));
        } else {
            builder.append(File.separator).append("export").append(File.separator).append(entityName).append("s").append(File.separator);
        }
        builder.append(entityName);
        builder.append('_');
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        builder.append(sdf.format(new Date()));
        return builder.toString();
    }

    private static String getDefaultPathString(Class cls) {
        if (cls == null) {
            return "";
        }
        String objName = cls.getSimpleName().toLowerCase();
        return ExportEntityHelper.getDefaultPathString(objName);
    }

    private static RadioBoxWidget<String> getObjectSelectionWidget(int size, boolean forList) {
        RadioBoxWidget objectSelectionWidget = new RadioBoxWidget(false);
        objectSelectionWidget.setItemsSupplier(() -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(Messages.Only_selected_objects);
            list.add(Messages.All_Objects);
            return list;
        });
        if (size == 0 && forList) {
            objectSelectionWidget.valueProperty().set((Object)Messages.All_Objects);
            objectSelectionWidget.setDisabledItemChecker(value -> value.equals(Messages.Only_selected_objects));
        } else if (!forList) {
            objectSelectionWidget.valueProperty().set((Object)Messages.Only_selected_objects);
            objectSelectionWidget.setDisabledItemChecker(value -> value.equals(Messages.All_Objects));
        } else {
            objectSelectionWidget.valueProperty().set((Object)Messages.Only_selected_objects);
        }
        return objectSelectionWidget;
    }

    private static CheckBoxWidget getExtraParametersCheckBox() {
        CheckBoxWidget widget = new CheckBoxWidget(false);
        widget.setText(Messages.Use_additional_parameters);
        return widget;
    }

    private static CardsContainer getExtraParametersContainer(CheckBoxWidget widget, DateValueWidget startDate, DateValueWidget endDate, EntityBoxWidget<Organization> agency, EntityBoxWidget<Organization> subAgency, EntityBoxWidget<SalesPoint> salesPoint, EntityBoxWidget<Organization> client) {
        startDate.valueProperty().set((Object)DateUtils.asLocalDate((Date)new Date()));
        endDate.valueProperty().set((Object)DateUtils.asLocalDate((Date)new Date()));
        GridContainer gridContainer = new GridContainer(2);
        gridContainer.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Start_date2, (Node)startDate), new GridCell(Messages.Finish_date2, (Node)endDate), new GridCell(Messages.Agency, agency), new GridCell(Messages.SubAgency, subAgency), new GridCell(Messages.Dimension_sales_point, salesPoint), new GridCell(Messages.Client, client)});
        CardsContainer container = new CardsContainer();
        container.getCards().add((Object)new Card("additionalParameters", UiCardsContainer.Style.COLLAPSED, Messages.Extra_options, (Node)gridContainer));
        container.setDisable(true);
        widget.selectedProperty().addListener((obj, oldValue, newValue) -> container.setDisable(newValue == false));
        return container;
    }

    private static VBox buildContainer(FileChooserWidget fileWidget, RadioBoxWidget<String> fileFormatWidget, RadioBoxWidget<String> objectSelectionWidget, CheckBoxWidget extraParametersCheckBox, CardsContainer extraParametersContainer) {
        VBox wrap = new VBox();
        wrap.getStyleClass().add((Object)"export-dialog-pane");
        GridContainer container = new GridContainer(6);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Helper_File, (Node)fileWidget);
        cell.setColSpan(6);
        cells.add(cell);
        cell = new GridCell(Messages.Helper_Format, fileFormatWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
        cell = new GridCell(Messages.Helper_Objects, objectSelectionWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
        cell = new GridCell((Node)extraParametersCheckBox);
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
        container.getCells().addAll(cells);
        wrap.getChildren().addAll((Object[])new Node[]{container, extraParametersContainer});
        return wrap;
    }

    private static GridContainer buildContainer(FileChooserWidget fileWidget, RadioBoxWidget<String> fileFormatWidget, RadioBoxWidget<String> objectSelectionWidget) {
        GridContainer container = ExportEntityHelper.buildContainerWithoutObjectSelection(fileWidget, fileFormatWidget);
        GridCell cell = new GridCell(Messages.Helper_Objects, objectSelectionWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        container.getCells().add((Object)cell);
        return container;
    }

    private static GridContainer buildContainerWithoutObjectSelection(FileChooserWidget fileWidget, RadioBoxWidget<String> fileFormatWidget) {
        GridContainer container = new GridContainer(6);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Helper_File, (Node)fileWidget);
        cell.setColSpan(6);
        cells.add(cell);
        cell = new GridCell(Messages.Helper_Format, fileFormatWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    private static void updateFileChooserWidgetFromLastFile(FileChooserWidget fileChooserWidget, boolean xmlAvailable, boolean xlsAndCsvAvailable) {
        File file = ClientSettings.get().getLastExportFile();
        if (file == null) {
            return;
        }
        fileChooserWidget.getFiles().clear();
        fileChooserWidget.getFiles().add((Object)file);
        String extension = FilenameUtils.getExtension((String)file.getPath());
        if (TextUtil.isBlank((String)extension)) {
            return;
        }
        fileChooserWidget.setFileExtension('.' + extension);
        switch (extension) {
            case "zip": {
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.zipExtensionFilter()));
                break;
            }
            case "xls": {
                if (!xlsAndCsvAvailable) break;
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.xlsExtensionFilter()));
                break;
            }
            case "csv": {
                if (!xlsAndCsvAvailable) break;
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.csvExtensionFilter()));
                break;
            }
            case "xml": {
                if (!xmlAvailable) break;
                fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(ExportEntityHelper.xmlExtensionFilter()));
            }
        }
    }

    private static FileChooser.ExtensionFilter zipExtensionFilter() {
        return new FileChooser.ExtensionFilter("zip", new String[]{"*.zip"});
    }

    private static FileChooser.ExtensionFilter xmlExtensionFilter() {
        return new FileChooser.ExtensionFilter("xml", new String[]{"*.xml"});
    }

    private static FileChooser.ExtensionFilter xlsExtensionFilter() {
        return new FileChooser.ExtensionFilter("xls", new String[]{"*.xls"});
    }

    private static FileChooser.ExtensionFilter csvExtensionFilter() {
        return new FileChooser.ExtensionFilter("csv", new String[]{"*.csv"});
    }

    private ExportEntityHelper() {
    }

    static {
        PATHS.put(BookingFile.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "booking-files" + File.separator);
        PATHS.put(Organization.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "organizations" + File.separator);
        PATHS.put(Person.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "persons" + File.separator);
        PATHS.put(SalesPoint.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "salespoints" + File.separator);
        PATHS.put(Contract.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "contracts" + File.separator);
        PATHS.put(BillingTransaction.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "transactions" + File.separator);
        PATHS.put(Shipment.class.getSimpleName().toLowerCase(), File.separator + "export" + File.separator + "shipments" + File.separator);
    }
}

