/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ExportHelperService;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.XMLExportHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StandardXMLExportFXHandler
implements XMLExportHandler {
    private static final Logger log = LoggerFactory.getLogger(StandardXMLExportFXHandler.class);
    private static final String ENTITY_ELEMENT_NAME = "entity";
    private static final String UID_ATTRIBUTE_NAME = "uid";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String EQUIVALENT_FARE_ELEMENT_NAME = "equivalentFare";
    private static final String TOTAL_EQUIVALENT_FARE_ELEMENT_NAME = "totalEquivalentFare";
    private static final String SUPPLIER_ELEMENT_NAME = "supplier";
    private static final String AGENCY_ELEMENT_NAME = "agency";
    private static final String SUBAGENCY_ELEMENT_NAME = "subagency";
    private static final String VENDOR_FOPS_ELEMENT_NAME = "vendorFops";
    private static final String SUBAGENT_FOPS_ELEMENT_NAME = "subagentFops";
    private static final String CLIENT_FOPS_ELEMENT_NAME = "clientFops";
    private static final String COMMISSIONS_ELEMENT_NAME = "commissions";
    private static final String CURRENCY_RATE_ELEMENT_NAME = "currencyRate";
    private static final String TEXT_ELEMENT_NAME = "text";
    private static final String ITEM_ELEMENT_NAME = "item";
    private final HashMap<String, EntityContainer<Organization>> supplierMap = new HashMap();
    private final HashMap<String, EntityContainer<Organization>> agencyMap = new HashMap();
    private final HashMap<String, EntityContainer<Organization>> subagencyMap = new HashMap();
    private final HashMap<String, MiscUtil.Pair<Map<String, List<GeneralProductFop>>, List<GeneralProductCommission>>> fopsAndCommissionsMap = new HashMap();
    private final HashMap<String, BigDecimal> totalEquivalentFareMap = new HashMap();
    private final HashMap<String, List<CommonProductIndex>> indexlistMap = new HashMap();
    private final HashMap<EntityReference<BookingFile>, EntityContainer<BookingFile>> bookingFileContainerMap = new HashMap();

    public String getId() {
        return "standardXmlExportFXHandler";
    }

    /*
     * WARNING - void declaration
     */
    public <T extends BaseEntity> void updateDocument(List<T> entities, Document document) throws Exception {
        String uid;
        String type;
        Element element;
        Node node;
        int i;
        ArrayList<String> productTypesAttributeValues = new ArrayList<String>();
        HashMap<String, String> productFopElementTypes = new HashMap<String, String>();
        HashMap<String, String> commissionElementTypes = new HashMap<String, String>();
        HashSet<String> commissionTypes = new HashSet<String>();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (ProductHandler handler : HandlersRegistry.get().getAllProductHandlers()) {
            EntityCollection commissionsCollection;
            String productClassName = handler.getProductClass().getName();
            productTypesAttributeValues.add(productClassName);
            EntityType entityType = (EntityType)metaRegistry.getEntities().get(productClassName);
            if (entityType == null) continue;
            for (String fopElementName : Arrays.asList(VENDOR_FOPS_ELEMENT_NAME, SUBAGENT_FOPS_ELEMENT_NAME, CLIENT_FOPS_ELEMENT_NAME)) {
                EntityCollection fopsCollection = (EntityCollection)entityType.getCollections().get(fopElementName);
                if (fopsCollection == null || fopsCollection.getElementType() == null) continue;
                productFopElementTypes.put(productClassName, fopsCollection.getElementType());
                break;
            }
            if ((commissionsCollection = (EntityCollection)entityType.getCollections().get(COMMISSIONS_ELEMENT_NAME)) == null || commissionsCollection.getElementType() == null) continue;
            commissionElementTypes.put(productClassName, commissionsCollection.getElementType());
        }
        commissionTypes.add(Commission.class.getName());
        commissionTypes.add(GeneralProductCommission.class.getName());
        NodeList nodes = document.getElementsByTagName(ENTITY_ELEMENT_NAME);
        HashMap<String, void> commissionRates = new HashMap<String, void>();
        for (i = 0; i < nodes.getLength(); ++i) {
            ValidationMessage validationMessage;
            BaseProduct product;
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute(UID_ATTRIBUTE_NAME);
            if (TextUtil.isBlank((String)type) || TextUtil.isBlank((String)uid)) continue;
            if (productTypesAttributeValues.contains(type)) {
                String commissionType;
                String productFopType;
                EntityContainer subagencyContainer;
                EntityContainer agencyContainer;
                product = this.findProductByUid(entities, XHelper.getClass((String)type), uid);
                if (product == null) {
                    log.error(String.format("product with type %s and uid %s not found!", type, uid));
                    try {
                        log.error(XUtil.toString((Document)document));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NodeList children = node.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 1 || !SUPPLIER_ELEMENT_NAME.equals(child.getNodeName()) && !AGENCY_ELEMENT_NAME.equals(child.getNodeName()) && !SUBAGENCY_ELEMENT_NAME.equals(child.getNodeName()) && !VENDOR_FOPS_ELEMENT_NAME.equals(child.getNodeName()) && !SUBAGENT_FOPS_ELEMENT_NAME.equals(child.getNodeName()) && !CLIENT_FOPS_ELEMENT_NAME.equals(child.getNodeName())) continue;
                    node.removeChild(child);
                    --j;
                }
                LinkedHashMap<String, BaseEntity> organizations = new LinkedHashMap<String, BaseEntity>();
                EntityContainer supplierContainer = this.supplierMap.get(product.getUid());
                if (supplierContainer == null) {
                    supplierContainer = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getSupplierContainer(ServiceInvocationContext.get(), product);
                    this.supplierMap.put(product.getUid(), (EntityContainer<Organization>)supplierContainer);
                }
                if (supplierContainer != null) {
                    organizations.put(SUPPLIER_ELEMENT_NAME, supplierContainer.getEntity());
                }
                if ((agencyContainer = this.agencyMap.get(product.getUid())) == null) {
                    agencyContainer = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getAgencyContainer(ServiceInvocationContext.get(), product);
                    this.agencyMap.put(product.getUid(), (EntityContainer<Organization>)agencyContainer);
                }
                if (agencyContainer != null) {
                    organizations.put(AGENCY_ELEMENT_NAME, agencyContainer.getEntity());
                }
                if ((subagencyContainer = this.subagencyMap.get(product.getUid())) == null) {
                    subagencyContainer = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getSubagencyContainer(ServiceInvocationContext.get(), product);
                    this.subagencyMap.put(product.getUid(), (EntityContainer<Organization>)subagencyContainer);
                }
                if (subagencyContainer != null) {
                    organizations.put(SUBAGENCY_ELEMENT_NAME, subagencyContainer.getEntity());
                }
                for (Map.Entry entry : organizations.entrySet()) {
                    String organizationElementName = (String)entry.getKey();
                    Organization organization = (Organization)entry.getValue();
                    Element organizationElement = node.getOwnerDocument().createElement(organizationElementName);
                    organizationElement.setAttribute(TYPE_ATTRIBUTE_NAME, Organization.class.getName());
                    organizationElement.setAttribute(UID_ATTRIBUTE_NAME, organization.getUid());
                    node.appendChild(organizationElement);
                }
                LinkedHashMap fops = new LinkedHashMap();
                ArrayList commissions = new ArrayList();
                ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                Date issueDate = null;
                if (handler != null) {
                    MiscUtil.Pair fopsAndCommissions = this.fopsAndCommissionsMap.get(product.getUid());
                    if (fopsAndCommissions == null) {
                        fopsAndCommissions = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getFopsAndCommissions(ServiceInvocationContext.get(), product, VENDOR_FOPS_ELEMENT_NAME, SUBAGENT_FOPS_ELEMENT_NAME, CLIENT_FOPS_ELEMENT_NAME);
                        this.fopsAndCommissionsMap.put(product.getUid(), (MiscUtil.Pair<Map<String, List<GeneralProductFop>>, List<GeneralProductCommission>>)fopsAndCommissions);
                    }
                    fops.putAll((Map)fopsAndCommissions.getFirst());
                    commissions.addAll((Collection)fopsAndCommissions.getSecond());
                    issueDate = handler.findIssueDate(product);
                }
                if (fops.size() > 0 && (productFopType = (String)productFopElementTypes.get(product.getClass().getName())) != null) {
                    for (Map.Entry entry : fops.entrySet()) {
                        String fopsElementName = (String)entry.getKey();
                        List productFops = (List)entry.getValue();
                        if (productFops.size() <= 0) continue;
                        Element fopsElement = node.getOwnerDocument().createElement(fopsElementName);
                        for (GeneralProductFop productFop : productFops) {
                            Element itemElement = node.getOwnerDocument().createElement(ITEM_ELEMENT_NAME);
                            itemElement.setAttribute(TYPE_ATTRIBUTE_NAME, productFopType);
                            itemElement.setAttribute(UID_ATTRIBUTE_NAME, productFop.getUid());
                            fopsElement.appendChild(itemElement);
                        }
                        node.appendChild(fopsElement);
                    }
                }
                if (commissions.size() > 0 && (commissionType = (String)commissionElementTypes.get(product.getClass().getName())) != null && commissions.size() > 0) {
                    Element commissionsElement = node.getOwnerDocument().createElement(COMMISSIONS_ELEMENT_NAME);
                    for (GeneralProductCommission commission : commissions) {
                        Element itemElement = node.getOwnerDocument().createElement(ITEM_ELEMENT_NAME);
                        itemElement.setAttribute(TYPE_ATTRIBUTE_NAME, commissionType);
                        itemElement.setAttribute(UID_ATTRIBUTE_NAME, commission.getUid());
                        commissionsElement.appendChild(itemElement);
                    }
                    node.appendChild(commissionsElement);
                }
                for (GeneralProductCommission commission : commissions) {
                    void var27_35;
                    if (commission.getAmount() == null || commission.getAmount().getCurrency() == null) continue;
                    if (type.equals(Product.class.getName())) {
                        BigDecimal bigDecimal = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getCurrencyRateForAirProduct(ServiceInvocationContext.get(), commission, product);
                    } else {
                        BigDecimal bigDecimal = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getCurrencyRate(ServiceInvocationContext.get(), commission, issueDate);
                    }
                    commissionRates.put(commission.getUid(), var27_35);
                }
            }
            if (type.equals(Product.class.getName())) {
                product = (Product)this.findProductByUid(entities, Product.class, uid);
                BigDecimal equivalentFare = product != null ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO;
                Text equivalentFareTextNode = node.getOwnerDocument().createTextNode(equivalentFare != null ? equivalentFare.toString() : BigDecimal.ZERO.toString());
                Element equivalentFareElement = node.getOwnerDocument().createElement(EQUIVALENT_FARE_ELEMENT_NAME);
                equivalentFareElement.appendChild(equivalentFareTextNode);
                node.appendChild(equivalentFareElement);
                BigDecimal totalEquivalentFare = null;
                if (product != null) {
                    totalEquivalentFare = this.totalEquivalentFareMap.get(product.getUid());
                }
                if (totalEquivalentFare == null) {
                    totalEquivalentFare = product != null ? ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getTotalEquivalentFareFromAirProductHelper(ServiceInvocationContext.get(), product) : BigDecimal.ZERO;
                    this.totalEquivalentFareMap.put(product.getUid(), totalEquivalentFare);
                }
                Text totalEquivalentFareTextNode = node.getOwnerDocument().createTextNode(totalEquivalentFare != null ? totalEquivalentFare.toString() : BigDecimal.ZERO.toString());
                Element totalEquivalentFareElement = node.getOwnerDocument().createElement(TOTAL_EQUIVALENT_FARE_ELEMENT_NAME);
                totalEquivalentFareElement.appendChild(totalEquivalentFareTextNode);
                node.appendChild(totalEquivalentFareElement);
            }
            if (!type.equals(ValidationMessage.class.getName()) || (validationMessage = this.findEntityByUid(entities, ValidationMessage.class, uid)) == null || validationMessage.getMessage() == null) continue;
            Text textTextNode = node.getOwnerDocument().createTextNode(validationMessage.getMessage().toString());
            Element textElement = node.getOwnerDocument().createElement(TEXT_ELEMENT_NAME);
            textElement.appendChild(textTextNode);
            node.appendChild(textElement);
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            BigDecimal rate;
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute(UID_ATTRIBUTE_NAME);
            if (TextUtil.isBlank((String)type) || TextUtil.isBlank((String)uid) || !commissionTypes.contains(type) || (rate = (BigDecimal)commissionRates.get(uid)) == null) continue;
            Text rateTextNode = node.getOwnerDocument().createTextNode(rate.toString());
            Element rateElement = node.getOwnerDocument().createElement(CURRENCY_RATE_ELEMENT_NAME);
            rateElement.appendChild(rateTextNode);
            node.appendChild(rateElement);
        }
    }

    private <T extends BaseEntity, C extends BaseEntity> C findEntityByUid(List<T> entities, Class<C> type, String uid) throws Exception {
        for (BaseEntity entity : entities) {
            BaseEntity object = EntityStorageHelper.findNestedEntity((BaseEntity)entity, (String)uid, type, new HashSet());
            if (object == null) continue;
            long date2 = System.currentTimeMillis();
            return (C)object;
        }
        return null;
    }

    private <T extends BaseEntity, C extends BaseProduct> BaseProduct findProductByUid(List<T> entities, Class<C> type, String uid) throws Exception {
        BaseProduct product = (BaseProduct)this.findEntityByUid(entities, type, uid);
        if (product != null) {
            return product;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)uid));
        List indexList = this.indexlistMap.get(uid);
        if (indexList == null) {
            indexList = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), CommonProductIndex.class, query);
            this.indexlistMap.put(uid, indexList);
        }
        EntityContainer bookingFileContainer = null;
        if (!indexList.isEmpty() && (bookingFileContainer = this.bookingFileContainerMap.get(((CommonProductIndex)indexList.get(0)).getSource())) == null) {
            bookingFileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ((CommonProductIndex)indexList.get(0)).getSource());
            this.bookingFileContainerMap.put((EntityReference<BookingFile>)((CommonProductIndex)indexList.get(0)).getSource(), (EntityContainer<BookingFile>)bookingFileContainer);
        }
        if (bookingFileContainer != null) {
            return BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()));
        }
        return null;
    }
}

