/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.AbstractBookingFileFiscalSelectFopsDialog;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

abstract class AbstractBookingFileFiscalParamDialog {
    protected final Control source;

    AbstractBookingFileFiscalParamDialog(Control source) {
        this.source = source;
    }

    public void showDialog(Set<EntityReference<BookingFile>> bfReferences, List<String> selectedProductUids) {
        Notifications.get().submitTask(() -> {
            ArrayList<Message> errorMessages = new ArrayList<Message>();
            ArrayList<EntityContainer> bookingContainers = new ArrayList<EntityContainer>();
            for (EntityReference bfReference : bfReferences) {
                EntityContainer bfContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfReference);
                if (EntityStorageHelper.nonEmpty((EntityContainer)bfContainer)) {
                    bookingContainers.add(bfContainer);
                    continue;
                }
                errorMessages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Fiscal_failed_resolving_booking_file, (Object[])new Object[]{bfReference}));
            }
            if (errorMessages.isEmpty()) {
                FxUtil.waitForFxThread(() -> this.showDialog(bookingContainers, selectedProductUids));
            } else {
                Notifications.get().showMessages(errorMessages);
            }
        }, Messages.Notifications_getting_data);
    }

    public void showDialog(EntityContainer<BookingFile> bfContainer, String selectedProductUid) {
        this.showDialog(Collections.singletonList(bfContainer), Collections.singletonList(selectedProductUid));
    }

    private void showDialog(List<EntityContainer<BookingFile>> bookingContainers, List<String> selectedProductUids) {
        AbstractBookingFileFiscalSelectFopsDialog fopsDialog = this.createSelectFopsDialog();
        List<String> selectedAndRealatedProductUids = this.getSelectedAndRelatedProductUids(bookingContainers, selectedProductUids);
        fopsDialog.showDialog(bookingContainers, selectedAndRealatedProductUids);
    }

    private List<String> getSelectedAndRelatedProductUids(Collection<EntityContainer<BookingFile>> bookingFiles, Collection<String> selectedProductUids) {
        ArrayList<String> result = new ArrayList<String>(selectedProductUids);
        Map<String, BaseProduct> productMap = bookingFiles.stream().flatMap(ctr -> BookingHelper.getProducts((BookingFile)((BookingFile)ctr.getEntity())).stream()).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        for (String selectedProductUid : selectedProductUids) {
            BaseProduct previousProduct;
            BaseProduct product2 = productMap.get(selectedProductUid);
            if (product2 == null) continue;
            if (GeneralProductHelper.getStatus((BaseProduct)product2) == ProductStatus.REFUND) {
                result.addAll(this.getRelatedMcoUids(product2, MCOCategory.PENALTY));
                continue;
            }
            if (GeneralProductHelper.getStatus((BaseProduct)product2) != ProductStatus.SELL || (previousProduct = GeneralProductHelper.getHandler((BaseProduct)product2).getPreviousProduct(product2)) == null || GeneralProductHelper.getStatus((BaseProduct)previousProduct) != ProductStatus.EXCHANGE) continue;
            result.addAll(this.getRelatedMcoUids(product2, MCOCategory.REBOOKING));
            result.add(previousProduct.getUid());
            result.addAll(this.getRelatedMcoUids(previousProduct, MCOCategory.REBOOKING));
        }
        return result;
    }

    private List<String> getRelatedMcoUids(BaseProduct product, MCOCategory mcoCategory) {
        return GeneralProductHelper.getMcoByRelatedProduct((BaseProduct)product).stream().filter(prod -> GeneralProductHelper.getHandler((BaseProduct)prod).getMCOCategory(prod) == mcoCategory).map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    abstract AbstractBookingFileFiscalSelectFopsDialog createSelectFopsDialog();
}

