/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalPreviewContainer;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalPreviewContainerInner;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.ReceiptHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.fiscal.FiscalReceiptHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.control.Control;

abstract class AbstractBookingFileFiscalPreviewDialog {
    private final Control source;

    AbstractBookingFileFiscalPreviewDialog(Control source) {
        this.source = source;
    }

    void showDialog(Map<String, Object> data) {
        BookingFileFiscalPreviewContainer body = this.createBody();
        List receiptContainers = (List)data.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
        List<BookingFileFiscalPreviewContainerInner> filledReceiptContainers = this.fillingBody(receiptContainers);
        ReadOnlyBooleanWrapper enableButton = new ReadOnlyBooleanWrapper(filledReceiptContainers.size() > 0);
        ((PlainGroupsWidget)body.getContent()).getViews().addAll(filledReceiptContainers);
        ((PlainGroupsWidget)body.getContent()).setConverter((view, index) -> index + 1 + ". " + ((ReceiptType)view.receiptTypeProperty().getValue()).toString());
        Dialog dialog = new Dialog();
        dialog.setBody((Node)body).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, this.getAcceptText(), () -> Notifications.get().submitTask(() -> {
            ArrayList<EntityContainer> printedReceiptContainers = new ArrayList<EntityContainer>();
            for (EntityContainer receiptContainer : receiptContainers) {
                try {
                    Receipt receipt = (Receipt)receiptContainer.getEntity();
                    if (receipt.getServiceType() == ReceiptServiceType.ATOL_FISCAL_DEVICE) {
                        FiscalReceiptHelper.registerFiscalReceipt(receipt);
                        Notifications.get().showFlashNotification(Messages.Fiscal_receipt_printed);
                    }
                    printedReceiptContainers.add(receiptContainer);
                }
                catch (Exception e) {
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)e, (Object[])new Object[0])});
                }
            }
            HashSet<String> outKeys = new HashSet<String>(Collections.singletonList(IBusFiscalReceiptContextKeys.CHANGED_DATA.name()));
            data.put(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name(), printedReceiptContainers);
            Map resultMap = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), this.getRegisterReceiptRoute(), data, outKeys);
            ChangeData changeData = (ChangeData)resultMap.get(IBusFiscalReceiptContextKeys.CHANGED_DATA.name());
            if (changeData != null && !changeData.getChanged().isEmpty()) {
                EventBus.get().publishSync((Event)new EntityModificationEvent(null, (Collection)changeData.getChanged().stream().map(it -> new EntityModification(it, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            }
        }, Messages.Notifications_saving_data), (BooleanExpression)enableButton).setExpandToParent(true).show((Node)this.source);
    }

    private List<BookingFileFiscalPreviewContainerInner> fillingBody(List<EntityContainer<Receipt>> receiptCtrs) {
        if (receiptCtrs == null || receiptCtrs.isEmpty()) {
            return Collections.emptyList();
        }
        return receiptCtrs.stream().map(EntityContainer::getEntity).map(receipt -> {
            BookingFileFiscalPreviewContainerInner receiptView = new BookingFileFiscalPreviewContainerInner(true);
            receiptView.receiptTypeProperty().setValue((Object)receipt.getReceiptData().getType());
            RichData richData = ReceiptHelper.fillHtmlTemplate(receipt);
            receiptView.getReceiptNode().setData(richData);
            return receiptView;
        }).collect(Collectors.toList());
    }

    private BookingFileFiscalPreviewContainer createBody() {
        return new BookingFileFiscalPreviewContainer(true);
    }

    abstract String getAcceptText();

    abstract String getRegisterReceiptRoute();
}

