/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public abstract class AbstractBookingFileFiscalSelectFopsDialog {
    protected final Control source;

    AbstractBookingFileFiscalSelectFopsDialog(Control source) {
        this.source = source;
    }

    public void showDialog(List<EntityContainer<BookingFile>> bookingContainers, List<String> selectedProductUids) {
        Notifications.get().submitTask(() -> {
            HashMap<BaseProduct, List<GeneralProductFop>> productToFops = new HashMap<BaseProduct, List<GeneralProductFop>>();
            ArrayList<NestedEntityReference<BookingFile, BaseProduct>> productsReferences = new ArrayList<NestedEntityReference<BookingFile, BaseProduct>>();
            for (EntityContainer bookingContainer : bookingContainers) {
                List bookingProducts = BookingHelper.getProducts((BookingFile)((BookingFile)bookingContainer.getEntity()));
                List productsUids = bookingProducts.stream().map(BaseIdentity::getUid).collect(Collectors.toList());
                ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getClientFops(ServiceInvocationContext.get(), bookingContainer.toReference(), productsUids).forEach(fopsResult -> {
                    BaseProduct product;
                    List<GeneralProductFop> filteredFops = this.filterProductFops(fopsResult.getFops(), fopsResult.getStatus());
                    if (!filteredFops.isEmpty() && !(product = bookingProducts.stream().filter(p -> MiscUtil.equals((Object)p.getUid(), (Object)fopsResult.getProductUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Missing product!", (Object[])new Object[0]))).getFopDetalizations().isEmpty()) {
                        productToFops.put(product, filteredFops);
                        productsReferences.add(new NestedEntityReference(bookingContainer, (BaseEntity)product));
                    }
                });
            }
            if (productToFops.isEmpty()) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Fiscal_no_Fops_to_print_receipt, (Object[])new Object[0])});
            } else {
                this.showSelectFopsDialog(productToFops, productsReferences, selectedProductUids);
            }
        }, Messages.Notifications_getting_data);
    }

    protected ReceiptServiceType getReceiptServiceType() {
        return ReceiptServiceType.ATOL_FISCAL_DEVICE;
    }

    protected abstract void showSelectFopsDialog(Map<BaseProduct, List<GeneralProductFop>> var1, List<NestedEntityReference<BookingFile, BaseProduct>> var2, List<String> var3) throws Exception;

    protected abstract List<GeneralProductFop> filterProductFops(List<GeneralProductFop> var1, ProductStatus var2);
}

