/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalPayTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalSelectFopsPayContainer;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.AbstractBookingFileFiscalSelectFopsDialog;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.BookingFileFiscalPayPreviewDialog;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class BookingFileFiscalPaySelectFopsDialog
extends AbstractBookingFileFiscalSelectFopsDialog {
    protected BookingFileFiscalPaySelectFopsDialog(Control source) {
        super(source);
    }

    @Override
    protected void showSelectFopsDialog(Map<BaseProduct, List<GeneralProductFop>> productToFops, List<NestedEntityReference<BookingFile, BaseProduct>> productsReferences, List<String> selectedProductUids) throws Exception {
        ArrayList<BookingFileFiscalPayTableVM> modelVM = new ArrayList<BookingFileFiscalPayTableVM>();
        for (Map.Entry<BaseProduct, List<GeneralProductFop>> entry : productToFops.entrySet()) {
            BaseProduct product = entry.getKey();
            for (GeneralProductFop fop : entry.getValue()) {
                BookingFileFiscalPayTableVM productVM = new BookingFileFiscalPayTableVM();
                productVM.setNumberBookingFile(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
                productVM.setNameProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                productVM.setServiceFOP(!GeneralProductHelper.isPaymentFop((GeneralProductFop)fop));
                productVM.setPaymentType(fop.getType());
                productVM.setAmount(fop.getEquivalentAmount());
                productVM.setAmountToPay(fop.getEquivalentAmount());
                productVM.setIsPayment(selectedProductUids.contains(product.getUid()));
                productVM.setProductFop(fop);
                productVM.setProduct(product);
                productVM.setPayer(fop.getPayer());
                modelVM.add(productVM);
            }
        }
        FxUtil.waitForFxThread(() -> {
            final BookingFileFiscalSelectFopsPayContainer body = this.createBody();
            TableWidgetController<TableWidget<BookingFileFiscalPayTableVM>, BookingFileFiscalPayTableVM> controller = new TableWidgetController<TableWidget<BookingFileFiscalPayTableVM>, BookingFileFiscalPayTableVM>(){

                public TableWidget<BookingFileFiscalPayTableVM> getView() {
                    return body.getFopsTableBoxNode();
                }
            };
            controller.readData(modelVM);
            VBox vBody = new VBox(new Node[]{body});
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Fiscal_to_pay).setAutoClose(false).setBody((Node)vBody).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Pay, () -> this.lambda$null$6(vBody, (TableWidgetController)controller, modelVM, productsReferences, body, dialog)).setExpandToParent(true).show((Node)this.source);
        });
    }

    private Map<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> mapToProductToPayReference(Collection<BookingFileFiscalPayTableVM> modelVM, List<NestedEntityReference<BookingFile, BaseProduct>> productsReferences) {
        HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> result = new HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>>();
        modelVM.stream().filter(BookingFileFiscalPayTableVM::isIsPayment).forEach(vm -> {
            NestedEntityReference reference = productsReferences.stream().filter(ref -> MiscUtil.equals((Object)ref.getNestedEntityUid(), (Object)vm.getProduct().getUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Missing product reference!", (Object[])new Object[0]));
            result.computeIfAbsent(reference, ref -> new ArrayList()).add(new NestedEntityReference((EntityReference)reference, vm.getProductFop().getUid(), Fop.class, null));
        });
        return result;
    }

    private List<Node> validateDialog(Collection<BookingFileFiscalPayTableVM> modelVM) {
        ArrayList<Node> result = new ArrayList<Node>();
        List<BookingFileFiscalPayTableVM> selectedPositions = modelVM.stream().filter(BookingFileFiscalPayTableVM::isIsPayment).collect(Collectors.toList());
        if (selectedPositions.isEmpty()) {
            result.add((Node)MessagePane.error((String)Messages.Fiscal_no_product_selected));
        } else {
            selectedPositions.forEach(vm -> {
                if (MiscUtil.compare((Comparable)vm.getAmount(), (Comparable)vm.getAmountToPay()) < 0) {
                    result.add((Node)MessagePane.error((String)L10nResourcesManager.replace((String)Messages.Fiscal_payment_amount_does_not_match, (Object[])new Object[]{vm.getNameProduct()})));
                }
            });
        }
        return result;
    }

    @Override
    protected List<GeneralProductFop> filterProductFops(List<GeneralProductFop> source, ProductStatus status) {
        Map availablePaymentTypes = Prefetched.getData().getFiscalSettings().getAvailablePaymentTypes();
        return source.stream().filter(fop -> (fop.getType() == PaymentType.CASH || fop.getType() == PaymentType.CREDIT_CARD_AGENCY || fop.getType() == PaymentType.CREDIT_CARD || fop.getType() == PaymentType.CREDIT_CARD_TCH || fop.getType() == PaymentType.TICKET || availablePaymentTypes.containsKey(fop.getType())) && status == ProductStatus.VOID || fop.getOperationDate() == null && !MiscUtil.isZero((BigDecimal)fop.getEquivalentAmount(), (boolean)true)).sorted(Comparator.comparing(GeneralProductHelper::isPaymentFop).reversed()).collect(Collectors.toList());
    }

    protected BookingFileFiscalSelectFopsPayContainer createBody() {
        BookingFileFiscalSelectFopsPayContainer body = new BookingFileFiscalSelectFopsPayContainer(false);
        body.getFopsTableBoxNode().getColumn("numberBookingFile").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().getColumn("nameProduct").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().getColumn("serviceFOP").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().getColumn("amount").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().getColumn("paymentType").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().getColumn("amountToPay").setNotEditable(Boolean.valueOf(true));
        body.getFopsTableBoxNode().setControlButtonsAvailability(ControlsPane.NONE);
        ((ComboBoxWidgetColumn)body.getFopsTableBoxNode().getColumn("paymentType")).setItemsSupplier(() -> Arrays.asList(PaymentType.values()));
        ((BooleanValueWidgetColumn)body.getFopsTableBoxNode().getColumn("serviceFOP")).setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean serviceFOP) {
                if (serviceFOP == null) {
                    serviceFOP = Boolean.FALSE;
                }
                return serviceFOP != false ? Messages.Fiscal_service_FOP : Messages.Fiscal_product_FOP;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        return body;
    }

    protected BookingFileFiscalPayPreviewDialog createFiscalPreviewDialog(Control source) {
        return new BookingFileFiscalPayPreviewDialog(source);
    }

    private /* synthetic */ void lambda$null$6(VBox vBody, TableWidgetController controller, Collection modelVM, List productsReferences, BookingFileFiscalSelectFopsPayContainer body, Dialog dialog) {
        vBody.getChildren().removeAll((Collection)vBody.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
        controller.writeData(modelVM);
        List<Node> listMessage = this.validateDialog(modelVM);
        if (!listMessage.isEmpty()) {
            listMessage.forEach(error -> vBody.getChildren().add(0, error));
            return;
        }
        Map<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> mapProductsToPayReference = this.mapToProductToPayReference(modelVM, productsReferences);
        Map<String, EntityReference> fopPayerMap = modelVM.stream().filter(BookingFileFiscalPayTableVM::isIsPayment).filter(BookingFileFiscalPayTableVM::isIncludePayerInReceipt).collect(Collectors.toMap(vm -> vm.getProductFop().getUid(), vm -> vm.getProductFop().getPayer()));
        Notifications.get().submitTask(() -> {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(IBusFiscalReceiptContextKeys.PRODUCTS_TO_PAY_REFERENCE.name(), mapProductsToPayReference);
            ctx.put(IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE.name(), this.getReceiptServiceType());
            ctx.put(IBusFiscalReceiptContextKeys.MESSAGE.name(), new ArrayList());
            ctx.put(IBusFiscalReceiptContextKeys.CLIENT_ADDRESS.name(), body.getClientAddressNode().getValue());
            ctx.put(IBusFiscalReceiptContextKeys.FOP_PAYER_MAP.name(), fopPayerMap);
            HashSet<String> outKeys = new HashSet<String>(Arrays.asList(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name(), IBusFiscalReceiptContextKeys.MESSAGE.name()));
            Map receiptMap = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "receipt:fiscal:create-fiscal-receipt", ctx, outKeys);
            List messages = (List)receiptMap.get(IBusFiscalReceiptContextKeys.MESSAGE.name());
            if (messages.isEmpty()) {
                FxUtil.waitForFxThread(() -> {
                    BookingFileFiscalPayPreviewDialog previewDialog = this.createFiscalPreviewDialog(this.source);
                    previewDialog.showDialog(receiptMap);
                    dialog.close();
                });
            } else {
                Notifications.get().showMessages((Collection)messages);
            }
        }, Messages.Notifications_saving_data);
    }
}

