/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.fiscal.FiscalReceiptCalculatedDataHolder;
import com.gridnine.xtrip.common.model.fiscal.PaymentData;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;
import com.gridnine.xtrip.common.model.system.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ReceiptHelper {
    static RichData fillHtmlTemplate(Receipt receipt) {
        return receipt.getReceiptData().getPayments().isEmpty() ? ReceiptHelper.fillHtmlTemplateInner(receipt) : ReceiptHelper.fillHtmlTemplateOld(receipt);
    }

    private static RichData fillHtmlTemplateInner(Receipt receipt) {
        RichData richData = new RichData();
        richData.setContentType(ContentType.HTML);
        ReceiptData receiptData = receipt.getReceiptData();
        FiscalReceiptCalculatedDataHolder fiscalDataHolder = new FiscalReceiptCalculatedDataHolder(receiptData);
        BigDecimal amountTotalValue = BigDecimal.ZERO;
        try (InputStream in = ReceiptHelper.class.getResourceAsStream("ReceiptTemplate.html");){
            String htmlString = IOUtils.toString((InputStream)in, (String)"utf-8");
            htmlString = receiptData.getType() != null ? htmlString.replace("${receiptType}", receiptData.getType().toString()) : htmlString.replace("${receiptType}", "");
            StringBuilder rows = new StringBuilder();
            for (ReceiptLine line : fiscalDataHolder.getReceiptLines()) {
                amountTotalValue = amountTotalValue.add(line.getTotal()).setScale(2);
                ReceiptVatType linevatType = line.getVatType();
                String vatType = linevatType == null ? Messages.Fiscal_without_vat_rate : (linevatType.equals((Object)ReceiptVatType.VAT_5_105) ? "5%" : (linevatType.equals((Object)ReceiptVatType.VAT_7_107) ? "7%" : (linevatType.equals((Object)ReceiptVatType.VAT_10_110) ? "10%" : (linevatType.equals((Object)ReceiptVatType.VAT_18_118) ? "18%" : linevatType.toString()))));
                String row = "<table class=\"text\"><tr><td>" + line.getPrintName() + "</td><td class=\"rightcol\">" + line.getQuantity().setScale(3) + " X " + line.getPrice().setScale(2) + " = " + line.getTotal().setScale(2) + "(" + vatType + ")</td></tr>";
                if (line.getPaymentObject() != null) {
                    row = row + "<tr><td style='padding-left:5%'>" + line.getPaymentObject() + "</td><td class=\"rightcol\"></td></tr>";
                }
                if (line.getPaymentMethod() != null) {
                    row = row + "<tr><td style='padding-left:5%'>" + line.getPaymentMethod() + "</td><td class=\"rightcol\"></td></tr>";
                }
                if (line.getSellType() == ReceiptLineSellType.OWN) {
                    row = row + "<tr><td>\u0421\u041e\u0411\u0421\u0422\u0412\u0415\u041d\u041d\u0410\u042f \u041f\u0420\u041e\u0414\u0410\u0416\u0410</td><td class=\"rightcol\"></td></tr>";
                } else if (line.getSellType() == ReceiptLineSellType.AGENT) {
                    row = row + "<tr><td>\u0410\u0413\u0415\u041d\u0422\u0421\u041a\u0410\u042f \u041f\u0420\u041e\u0414\u0410\u0416\u0410</td><td class=\"rightcol\"></td></tr>";
                    if (line.getSupplier() != null) {
                        String name = line.getSupplier().getName();
                        String phone = line.getSupplier().getPhoneNum();
                        String inn = line.getSupplier().getINN();
                        if (name != null || phone != null || inn != null) {
                            row = row + "<tr><td style='padding-left:5%'>(";
                            if (name != null) {
                                row = row + "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + name + ",";
                            }
                            if (phone != null) {
                                row = row + "\u0422\u0435\u043b\u0435\u0444\u043e\u043d: " + phone + ",";
                            }
                            if (inn != null) {
                                row = row + "\u0418\u041d\u041d " + inn;
                            }
                            row = row + ")</td><td class=\"rightcol\"></td></tr>";
                        }
                    }
                }
                row = row + "</table>";
                rows.append(row);
            }
            StringBuilder payments = new StringBuilder();
            for (Map.Entry entry : fiscalDataHolder.getPaymentsMap().entrySet()) {
                String row = "<table class=\"text\"><tr><td>" + entry.getKey() + "</td><td class=\"rightcol\">" + ((BigDecimal)entry.getValue()).setScale(2) + "</td></tr>";
                row = row + "</table>";
                payments.append(row);
            }
            htmlString = htmlString.replace("${rows}", rows);
            htmlString = htmlString.replace("${payments}", payments);
            htmlString = receiptData.getClentEmail() != null ? htmlString.replace("${email}", "<p>\u0410\u0434\u0440\u0435\u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u0430: " + receiptData.getClentEmail()) : htmlString.replace("${email}", "");
            htmlString = receiptData.getReceiptClient() != null ? htmlString.replace("${client}", "<div>\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f-\u043a\u043b\u0438\u0435\u043d\u0442:</div><div style='padding-left:5%'>\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + receiptData.getReceiptClient().getName() + ", \u0418\u041d\u041d: " + receiptData.getReceiptClient().getINN() + "</div>") : htmlString.replace("${client}", "");
            htmlString = htmlString.replace("${amountTotal}", amountTotalValue.toString());
            richData.setContent(htmlString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)ioe);
        }
        return richData;
    }

    @Deprecated
    private static RichData fillHtmlTemplateOld(Receipt receipt) {
        RichData richData = new RichData();
        richData.setContentType(ContentType.HTML);
        ReceiptData receiptData = receipt.getReceiptData();
        if (receiptData == null) {
            richData.setContentType(ContentType.HTML);
            richData.setContent("<h1 align=\"center\">\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445</h1>".getBytes(StandardCharsets.UTF_8));
            return richData;
        }
        BigDecimal amountTotalValue = BigDecimal.ZERO;
        try (InputStream in = ReceiptHelper.class.getResourceAsStream("ReceiptTemplate.html");){
            String row;
            String htmlString = IOUtils.toString((InputStream)in, (String)"utf-8");
            htmlString = receiptData.getType() != null ? htmlString.replace("${receiptType}", receiptData.getType().toString()) : htmlString.replace("${receiptType}", "");
            StringBuilder rows = new StringBuilder();
            for (Object line : receiptData.getItems()) {
                amountTotalValue = amountTotalValue.add(line.getTotal()).setScale(2);
                ReceiptVatType linevatType = line.getVatType();
                String vatType = linevatType == null ? Messages.Fiscal_without_vat_rate : (linevatType.equals((Object)ReceiptVatType.VAT_5_105) ? "5%" : (linevatType.equals((Object)ReceiptVatType.VAT_7_107) ? "7%" : (linevatType.equals((Object)ReceiptVatType.VAT_10_110) ? "10%" : (linevatType.equals((Object)ReceiptVatType.VAT_18_118) ? "18%" : linevatType.toString()))));
                row = "<table class=\"text\"><tr><td>" + line.getPrintName() + "</td><td class=\"rightcol\">" + line.getQuantity().setScale(3) + " X " + line.getPrice().setScale(2) + " = " + line.getTotal().setScale(2) + "(" + vatType + ")</td></tr>";
                if (line.getPaymentObject() != null) {
                    row = row + "<tr><td style='padding-left:5%'>" + line.getPaymentObject() + "</td><td class=\"rightcol\"></td></tr>";
                }
                if (line.getPaymentMethod() != null) {
                    row = row + "<tr><td style='padding-left:5%'>" + line.getPaymentMethod() + "</td><td class=\"rightcol\"></td></tr>";
                }
                if (line.getSellType() == ReceiptLineSellType.OWN) {
                    row = row + "<tr><td>\u0421\u041e\u0411\u0421\u0422\u0412\u0415\u041d\u041d\u0410\u042f \u041f\u0420\u041e\u0414\u0410\u0416\u0410</td><td class=\"rightcol\"></td></tr>";
                } else if (line.getSellType() == ReceiptLineSellType.AGENT) {
                    row = row + "<tr><td>\u0410\u0413\u0415\u041d\u0422\u0421\u041a\u0410\u042f \u041f\u0420\u041e\u0414\u0410\u0416\u0410</td><td class=\"rightcol\"></td></tr>";
                    if (line.getSupplier() != null) {
                        String name = line.getSupplier().getName();
                        String phone = line.getSupplier().getPhoneNum();
                        String inn = line.getSupplier().getINN();
                        if (name != null || phone != null || inn != null) {
                            row = row + "<tr><td style='padding-left:5%'>(";
                            if (name != null) {
                                row = row + "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + name + ",";
                            }
                            if (phone != null) {
                                row = row + "\u0422\u0435\u043b\u0435\u0444\u043e\u043d: " + phone + ",";
                            }
                            if (inn != null) {
                                row = row + "\u0418\u041d\u041d " + inn;
                            }
                            row = row + ")</td><td class=\"rightcol\"></td></tr>";
                        }
                    }
                }
                row = row + "</table>";
                rows.append(row);
            }
            HashMap<PaymentType, BigDecimal> paymentsMap = new HashMap<PaymentType, BigDecimal>();
            for (PaymentData payment : receiptData.getPayments()) {
                BigDecimal paymentAmount = (BigDecimal)paymentsMap.get(payment.getType());
                if (paymentAmount != null) {
                    paymentsMap.replace(payment.getType(), paymentAmount.add(payment.getAmount()));
                    continue;
                }
                paymentsMap.put(payment.getType(), payment.getAmount());
            }
            StringBuilder payments = new StringBuilder();
            for (Map.Entry entry : paymentsMap.entrySet()) {
                row = "<table class=\"text\"><tr><td>" + entry.getKey() + "</td><td class=\"rightcol\">" + ((BigDecimal)entry.getValue()).setScale(2) + "</td></tr>";
                row = row + "</table>";
                payments.append(row);
            }
            htmlString = htmlString.replace("${rows}", rows);
            htmlString = htmlString.replace("${payments}", payments);
            htmlString = receiptData.getClentEmail() != null ? htmlString.replace("${email}", "<p>\u0410\u0434\u0440\u0435\u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u0430: " + receiptData.getClentEmail()) : htmlString.replace("${email}", "");
            htmlString = htmlString.replace("${amountTotal}", amountTotalValue.toString());
            richData.setContent(htmlString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)ioe);
        }
        return richData;
    }
}

