/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.payment;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ListPaymentActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductPayClientFOPDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductPayClientFOPListAction
implements ListPaymentActions {
    @Override
    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    @Override
    public void execute(Control source, IndexListPane<?, ?> context, List<EntityIndex<BookingFile>> selectedItems, boolean alt) {
        if (selectedItems.size() > 1) {
            this.serviceMultipleSelection(selectedItems, context);
        } else {
            this.serviceSingleSelection(selectedItems, context);
        }
    }

    @Override
    public String getName() {
        return Messages.AirProduct_payClientFopInList;
    }

    @Override
    public Map<String, AclQuery> getACLQueryMap(IndexListPane<?, ?> context) {
        HashMap<String, AclQuery> aclQueryMap = new HashMap<String, AclQuery>();
        List selectedItems = context.getSelectedItems();
        for (EntityIndex item : selectedItems) {
            AclQuery aclQuery = AclQuery.AclQueryBuilder.get().entry(ModelAclResourceOperations.PAY.getId(), ModelRestrictionEntityResources.ENTITY_RESERVATION.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, null)).build();
            aclQueryMap.put(item.getNavigationKey(), aclQuery);
        }
        return aclQueryMap;
    }

    private void serviceSingleSelection(List<EntityIndex<BookingFile>> selectedItems, IndexListPane<?, ?> context) {
        EntityIndex<BookingFile> entityIndex = selectedItems.get(0);
        Notifications.get().submitTask(() -> {
            EntityReference bfRef = entityIndex.getSource();
            EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
            if (bfCtr == null) {
                Dialog.info((Node)context, (String)Messages.Order_Not_Found);
                return;
            }
            BaseProduct selectedProduct = BookingHelper.findProductByUid((String)entityIndex.getNavigationKey(), (BookingFile)((BookingFile)bfCtr.getEntity()));
            ProductFXHandler<BaseProduct, ?, ?, ?> fxHandler = ProductFXHandler.forProduct(selectedProduct);
            if (fxHandler != null && !ProductStatusHandler.getAllVoidStatuses().contains(fxHandler.getProductStatus(selectedProduct))) {
                ProductPayClientFOPDialog fopDialog = new ProductPayClientFOPDialog(selectedProduct.getUid(), (EntityReference<BookingFile>)bfRef, true);
                FxUtil.submitToFxThread(() -> fopDialog.show((Node)context));
            } else {
                Dialog.info((String)Messages.Operation_is_not_available_for_a_canceled_product);
            }
        }, context.getMutex());
    }

    private void serviceMultipleSelection(Collection<EntityIndex<BookingFile>> selectedItems, IndexListPane<?, ?> context) {
        Notifications.get().submitTask(() -> {
            Map<EntityReference<BookingFile>, List<String>> bfAndProductsUids = selectedItems.stream().collect(Collectors.groupingBy(EntityIndex::getSource)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(EntityIndex::getNavigationKey).collect(Collectors.toList())));
            ProductPayClientFOPDialog fopDialog = new ProductPayClientFOPDialog(bfAndProductsUids);
            FxUtil.submitToFxThread(() -> fopDialog.show((Node)context));
        }, context.getMutex());
    }
}

