/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.payment;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ListPaymentActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductRefusePayClientFOPDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductRefusePayClientFOPListAction
implements ListPaymentActions {
    @Override
    public boolean isEnabled(IndexListPane<?, ?> context) {
        return context.getSelectedItems().size() == 1;
    }

    @Override
    public void execute(Control source, IndexListPane<?, ?> context, List<EntityIndex<BookingFile>> selectedItems, boolean alt) {
        EntityIndex<BookingFile> entityIndex = selectedItems.get(0);
        Notifications.get().submitTask(() -> {
            EntityReference bfRef = entityIndex.getSource();
            EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
            if (bfCtr == null) {
                Dialog.info((Node)context, (String)Messages.Order_Not_Found);
                return;
            }
            BaseProduct selectedProduct = BookingHelper.findProductByUid((String)entityIndex.getNavigationKey(), (BookingFile)((BookingFile)bfCtr.getEntity()));
            ProductFXHandler<BaseProduct, ?, ?, ?> fxHandler = ProductFXHandler.forProduct(selectedProduct);
            if (fxHandler != null && !ProductStatusHandler.getAllVoidStatuses().contains(fxHandler.getProductStatus(selectedProduct))) {
                ProductRefusePayClientFOPDialog fopDialog = new ProductRefusePayClientFOPDialog(selectedProduct.getUid(), (EntityReference<BookingFile>)bfRef);
                FxUtil.submitToFxThread(() -> fopDialog.show((Node)source));
            } else {
                Dialog.info((String)Messages.Operation_is_not_available_for_a_canceled_product);
            }
        }, Messages.Refuse_Payment);
    }

    @Override
    public String getName() {
        return Messages.Product_refuseInList;
    }

    @Override
    public Map<String, AclQuery> getACLQueryMap(IndexListPane<?, ?> context) {
        HashMap<String, AclQuery> aclQueryMap = new HashMap<String, AclQuery>();
        List selectedItems = context.getSelectedItems();
        for (EntityIndex item : selectedItems) {
            AclQuery aclQuery = AclQuery.AclQueryBuilder.get().entry(ModelAclResourceOperations.PAY.getId(), ModelRestrictionEntityResources.ENTITY_RESERVATION.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, null)).build();
            aclQueryMap.put(item.getNavigationKey(), aclQuery);
        }
        return aclQueryMap;
    }
}

