/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.payment;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ListPaymentActions;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ProductPayClientFOPListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ProductRefusePayClientFOPListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ProductUnRefusePayClientFOPListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.payment.ProductUnpayClientFOPListAction;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class UnionPaymentsAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(InsuranceAccidentIndex.class, UniversalProductIndex.class, DeliveryIndex.class, MainHotelProductIndex.class, AeroexpressTicketIndex.class, RailwayProductIndex.class, InsuranceTouristicIndex.class, VisaProductIndex.class, AgencyMemoProductIndex.class, TransferIndex.class, CommonProductIndex.class, ProductIndex.class, CarRentalProductIndex.class, MCOFeesIndex.class);

    public List<ListPaymentActions> getActions(IndexListPane<?, ?> context) {
        return Arrays.asList(new ProductPayClientFOPListAction(), new ProductUnpayClientFOPListAction(), new ProductRefusePayClientFOPListAction(), new ProductUnRefusePayClientFOPListAction());
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.PAY;
    }

    public double getWeight() {
        return 25.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        Class indexType = context.getIndexType();
        return ALLOWED_TYPES.contains(indexType);
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return this.getActions(context).stream().anyMatch(action -> action.isEnabled(context));
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List enabledActions = this.getActions(context).stream().filter(action -> action.isEnabled(context)).collect(Collectors.toList());
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> enabledActions);
        widget.setConverter((StringConverter)new StringConverter<ListPaymentActions>(){

            public String toString(ListPaymentActions object) {
                return object.getName();
            }

            public ListPaymentActions fromString(String string) {
                return null;
            }
        });
        widget.setSortItems(false);
        widget.setNoNulls(true);
        if (!enabledActions.isEmpty()) {
            widget.setValue(enabledActions.get(0));
        }
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Choose_operation_type).setBody((Node)widget).setActionCaption(Messages.Choose).setActionHandler(() -> {
            if (((ListPaymentActions)widget.getValue()).isEnabled(context)) {
                Notifications.get().submitTask(() -> {
                    Map<String, AclQuery> aclQueryMap = ((ListPaymentActions)widget.getValue()).getACLQueryMap(context);
                    HashSet<String> notGranted = new HashSet<String>();
                    HashSet<String> granted = new HashSet<String>();
                    Set grantedIds = FxAclUtil.applyACL(aclQueryMap);
                    for (Map.Entry<String, AclQuery> entry : aclQueryMap.entrySet()) {
                        if (grantedIds.contains(entry.getKey())) {
                            granted.add(entry.getKey());
                            continue;
                        }
                        notGranted.add(entry.getKey());
                    }
                    if (granted.size() != 0) {
                        List<EntityIndex<BookingFile>> grantedItems = context.getSelectedItems().stream().filter(i -> granted.contains(i.getNavigationKey())).collect(Collectors.toList());
                        ((ListPaymentActions)widget.getValue()).execute(source, context, grantedItems, alt);
                    }
                    if (notGranted.size() != 0) {
                        StringBuilder message = new StringBuilder();
                        message.append(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Not_enough_permissions_for_operation).append(' ').append(this.getDescription(context));
                        if (notGranted.size() != aclQueryMap.size()) {
                            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                            SearchQuery query = new SearchQuery();
                            query.getCriteria().getCriterions().add(SearchCriterion.in((String)"navigationKey", (Object[])notGranted.toArray()));
                            query.getPreferredProperties().add(CommonProductIndex.Property.firstSystemNumber.name());
                            List indexes = entityService.search(ServiceInvocationContext.get(), CommonProductIndex.class, query);
                            if (indexes.size() != 0) {
                                String details = indexes.stream().filter(Objects::nonNull).map(CommonProductIndex::getFirstSystemNumber).filter(Objects::nonNull).collect(Collectors.joining("\n"));
                                message.append(' ').append(Messages.for_products).append("\n").append(details);
                            }
                        }
                        StandardNotifications.PERMISSION_DENIED.show(message.toString());
                    }
                }, context.getMutex());
            }
        }).show((Region)source);
    }

    public String getId() {
        return "union-payments";
    }

    public String getName(IndexListPane<?, ?> context) {
        return Messages.Union_payments_name;
    }

    public String getDescription(IndexListPane<?, ?> context) {
        return Messages.Union_payments_description;
    }
}

