/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.personal.data;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.PersonalDataService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataOrganizationRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Optional;
import javafx.scene.control.Control;

public class PersonalDataOrganizationProcessAction
implements RootEntityAction {
    public String getId() {
        return "personal-data-organization-process";
    }

    public double getWeight() {
        return 200.0;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        Mode mode = this.getMode(context);
        StandardActionIcons icon = null;
        if (mode == Mode.PROCESS_START) {
            icon = StandardActionIcons.PLAY;
        } else if (mode == Mode.PROCESS_STOP) {
            icon = StandardActionIcons.STOP;
        }
        return icon != null ? icon : StandardActionIcons.PLAY;
    }

    public String getName(RootEntityPane<?, ?> context) {
        PersonalDataRequestType type = this.getType(context);
        Mode mode = this.getMode(context);
        String name = null;
        if (type == PersonalDataRequestType.ERASURE_ORGANIZATION) {
            if (mode == null || mode == Mode.PROCESS_START) {
                name = Messages.personalDataErasureOrganizationProcessStart;
            } else if (mode == Mode.PROCESS_STOP) {
                name = Messages.personalDataErasureOrganizationProcessStop;
            }
        }
        return name != null ? name : "";
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        PersonalDataRequestType type = this.getType(context);
        Mode mode = this.getMode(context);
        String description = null;
        if (type == PersonalDataRequestType.ERASURE_ORGANIZATION) {
            if (mode == Mode.PROCESS_START) {
                description = Messages.personalDataErasureOrganizationProcessStartDescription;
            } else if (mode == Mode.PROCESS_STOP) {
                description = Messages.personalDataErasureOrganizationProcessStopDescription;
            }
        }
        return description;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && PersonalDataOrganizationRequest.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        Mode mode = this.getMode(context);
        return context.getMode() != EditingMode.CREATE && context.getMode() != EditingMode.VIEW && mode != null;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        PersonalDataRequestType type = this.getType(context);
        Mode mode = this.getMode(context);
        if (type != null && mode != null) {
            EntityContainer requestContainer = context.getData().getContainer();
            RootEntityPane.executeAction(context, () -> Notifications.get().submitTask(() -> {
                if (type == PersonalDataRequestType.ERASURE_ORGANIZATION) {
                    if (mode == Mode.PROCESS_START) {
                        ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).erasureOrganizationProcessStart(ServiceInvocationContext.get(), requestContainer.toReference());
                    } else if (mode == Mode.PROCESS_STOP) {
                        ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).erasureOrganizationProcessStop(ServiceInvocationContext.get(), requestContainer.toReference());
                    }
                }
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(requestContainer.toReference(), EntityModification.ModificationType.CHANGE)));
            }, context.getMutex()));
        }
    }

    private PersonalDataRequestType getType(RootEntityPane<?, ?> context) {
        return Optional.ofNullable(context.getData()).map(item -> item.getContainer()).map(item -> ((PersonalDataOrganizationRequest)item.getEntity()).getType()).orElse(null);
    }

    private Mode getMode(RootEntityPane<?, ?> context) {
        PersonalDataRequestStatus status = Optional.ofNullable(context.getData()).map(item -> item.getContainer()).map(item -> ((PersonalDataOrganizationRequest)item.getEntity()).getStatus()).orElse(null);
        if (status == PersonalDataRequestStatus.SEARCH_DONE || status == PersonalDataRequestStatus.PROCESS_INTERRUPTED || status == PersonalDataRequestStatus.PROCESS_FAILED) {
            return Mode.PROCESS_START;
        }
        if (status == PersonalDataRequestStatus.PROCESSING) {
            return Mode.PROCESS_STOP;
        }
        return null;
    }

    private static enum Mode {
        PROCESS_START,
        PROCESS_STOP;

    }
}

