/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receipts;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receipts.ListReceiptsAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirItineraryReceiptDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ItineraryReceiptDialog;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.InformationNoteType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductItineraryReceiptAction
implements ListReceiptsAction {
    public String getId() {
        return "product-itinerary-receipt";
    }

    @Override
    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null || dtp.getContainer() == null) {
            return false;
        }
        List<BaseProduct> products = this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity());
        return !products.isEmpty();
    }

    @Override
    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        BookingFile bf = (BookingFile)dtp.getContainer().getEntity();
        List<BaseProduct> products = this.getSuitableProducts(bf);
        Set<InformationNoteType> suitableTypes = this.getSuitableTypes(products);
        Notifications.get().submitTask(() -> {
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            DictQuery dictQuery = new DictQuery();
            dictQuery.getFields().add(BaseDictionary.Property.code.name());
            dictQuery.getFields().add(BaseDictionary.Property.translations.name());
            dictQuery.getFields().add(InformationNote.Property.priority.name());
            dictQuery.getFields().add(InformationNote.Property.persistent.name());
            dictQuery.getFields().add(InformationNote.Property.types.name());
            dictQuery.getSorting().put(InformationNote.Property.priority.name(), SortOrder.ASC);
            List notes = dictService.search(sic, InformationNote.class, dictQuery);
            List<DictItem<InformationNote>> filteredNotes = notes.stream().filter(item -> {
                Set types = (Set)item.getFields().get(InformationNote.Property.types.name());
                if (CollectionUtil.isEmpty((Collection)types)) return true;
                if (!types.stream().anyMatch(suitableTypes::contains)) return false;
                return true;
            }).collect(Collectors.toList());
            Map<BaseProduct, EntityReference<BookingFile>> products2Bookings = products.stream().collect(Collectors.toMap(obj -> obj, obj -> dtp.getContainer().toReference()));
            Node selectedView = ((CompactNavigatorWidget)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getProductsFull().getView().getContent()).getSelectedView();
            String selectedProductUid = (String)selectedView.getProperties().get((Object)"model-uid");
            ItineraryReceiptDialog receiptDialog = ClientRegistry.get().allOf(ItineraryReceiptDialog.TYPE).values().stream().filter(dialog -> dialog.getPaneClassList().contains(selectedView.getClass())).findFirst().orElse(null);
            if (receiptDialog != null) {
                ItineraryReceiptDialog finalReceiptDialog = receiptDialog;
                products2Bookings.keySet().removeIf(product -> !product.getClass().equals(finalReceiptDialog.getProductClass()));
            } else {
                products2Bookings.keySet().removeIf(product -> !(product instanceof Product));
                receiptDialog = new AirItineraryReceiptDialog();
            }
            receiptDialog.initDialog(source, products2Bookings, filteredNotes, selectedProductUid);
            FxUtil.submitToFxThread(receiptDialog::showDialog);
        }, context.getMutex());
    }

    @Override
    public String getName() {
        return Messages.Product_itinerary_receipt;
    }

    private Set<InformationNoteType> getSuitableTypes(List<BaseProduct> products) {
        HashSet<InformationNoteType> suitableTypes = new HashSet<InformationNoteType>();
        products.stream().map(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).findTravelSubject(baseProduct)).filter(Objects::nonNull).forEach(travelSubject -> {
            switch (travelSubject) {
                case AIR: {
                    suitableTypes.add(InformationNoteType.ITINERARY_RECEIPT_AVIA);
                    break;
                }
                case RAILWAY: {
                    suitableTypes.add(InformationNoteType.ITINERARY_RECEIPT_RAIL);
                    break;
                }
                case AEROEXPRESS: {
                    suitableTypes.add(InformationNoteType.ITINERARY_RECEIPT_AEROEXPRESS);
                    break;
                }
                case TRANSFER: {
                    suitableTypes.add(InformationNoteType.ITINERARY_RECEIPT_TRANSFER);
                }
            }
        });
        return suitableTypes;
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bf) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (bf == null) {
            return result;
        }
        bf.getReservations().stream().flatMap(r -> r.getProducts().stream().filter(baseProduct -> {
            TravelSubject travelSubject = ProductHandler.of((BaseProduct)baseProduct).findTravelSubject(baseProduct);
            return travelSubject == TravelSubject.AIR || travelSubject == TravelSubject.RAILWAY || travelSubject == TravelSubject.AEROEXPRESS || travelSubject == TravelSubject.TRANSFER;
        })).forEach(baseProduct -> {
            ProductStatus productStatus = GeneralProductHelper.getStatus((BaseProduct)baseProduct);
            if (!(ProductStatus.REFUND.equals((Object)productStatus) || ProductStatus.EXCHANGE.equals((Object)productStatus) || ProductStatusHandler.getAllVoidStatuses().contains(productStatus))) {
                result.add((BaseProduct)baseProduct);
            }
        });
        return result;
    }
}

