/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist;

import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ListReceiptsActionFromList;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ReceiptsFromListHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirItineraryReceiptDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ItineraryReceiptDialog;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.InformationNoteType;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class ProductItineraryReceiptListAction
implements ListReceiptsActionFromList {
    private static final List<TravelSubject> SUBJECTS = Arrays.asList(TravelSubject.AIR, TravelSubject.RAILWAY);

    @Override
    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    @Override
    public boolean isAvailable(IndexListPane<?, ?> context) {
        return CommonProductIndex.class.equals((Object)context.getIndexType()) && ReceiptsFromListHelper.containsOnlyAirOrRail(context.getSelectedItems()) && ReceiptsFromListHelper.containsSuitableProducts(context.getSelectedItems(), SUBJECTS);
    }

    @Override
    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        Map<String, EntityReference> productMap = selectedItems.stream().collect(Collectors.toMap(EntityIndex::getNavigationKey, index -> index.getSource()));
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            BookingFileService bfService = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
            Map products2Bookings = bfService.getProductsForItineraryAndRefundReceipt(sic, productMap);
            Map<BaseProduct, EntityReference<BookingFile>> filteredProducts2Bookings = products2Bookings.entrySet().stream().filter(entry -> this.isSuitableProduct((BaseProduct)entry.getKey())).collect(Collectors.toMap(entry -> (BaseProduct)entry.getKey(), entry -> (EntityReference)entry.getValue()));
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            DictQuery dictQuery = new DictQuery();
            dictQuery.getFields().add(BaseDictionary.Property.code.name());
            dictQuery.getFields().add(BaseDictionary.Property.translations.name());
            dictQuery.getFields().add(InformationNote.Property.priority.name());
            dictQuery.getFields().add(InformationNote.Property.persistent.name());
            dictQuery.getFields().add(InformationNote.Property.types.name());
            dictQuery.getSorting().put(InformationNote.Property.priority.name(), SortOrder.ASC);
            boolean containsAvia = filteredProducts2Bookings.keySet().stream().anyMatch(bp -> bp instanceof Product);
            InformationNoteType informationNoteType = containsAvia ? InformationNoteType.ITINERARY_RECEIPT_AVIA : InformationNoteType.ITINERARY_RECEIPT_RAIL;
            List notes = dictService.search(sic, InformationNote.class, dictQuery);
            List<DictItem<InformationNote>> filteredNotes = notes.stream().filter(item -> {
                Set types = (Set)item.getFields().get(InformationNote.Property.types.name());
                if (types == null) return true;
                if (types.isEmpty()) return true;
                if (!types.stream().anyMatch(arg_0 -> informationNoteType.equals(arg_0))) return false;
                return true;
            }).collect(Collectors.toList());
            ItineraryReceiptDialog receiptDialog = ClientRegistry.get().allOf(ItineraryReceiptDialog.TYPE).values().stream().filter(dialog -> dialog.getProductClass().equals(containsAvia ? Product.class : RailwayProduct.class)).findFirst().orElse(null);
            if (receiptDialog != null) {
                receiptDialog.initDialog(source, filteredProducts2Bookings, filteredNotes, null);
                FxUtil.submitToFxThread(receiptDialog::showDialog);
            } else {
                Map<BaseProduct, EntityReference<BookingFile>> filteredAirProducts2Bookings = filteredProducts2Bookings.entrySet().stream().filter(entry -> AirProductHelper.isAirProductOrEMD((BaseProduct)((BaseProduct)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                AirItineraryReceiptDialog airItineraryReceiptDialog = new AirItineraryReceiptDialog();
                airItineraryReceiptDialog.initDialog(source, filteredAirProducts2Bookings, filteredNotes, null);
                FxUtil.submitToFxThread(airItineraryReceiptDialog::showDialog);
            }
        }, Messages.Preparing_data_to_create_a_route_receipt);
    }

    @Override
    public String getName() {
        return Messages.Product_itinerary_receipt;
    }

    private boolean isSuitableProduct(BaseProduct baseProduct) {
        if (AirProductHelper.isAirProductOrEMD((BaseProduct)baseProduct) || baseProduct instanceof RailwayProduct || baseProduct instanceof AeroexpressTicket || baseProduct instanceof Transfer) {
            ProductStatus productStatus = GeneralProductHelper.getStatus((BaseProduct)baseProduct);
            return !ProductStatus.REFUND.equals((Object)productStatus) && !ProductStatus.EXCHANGE.equals((Object)productStatus) && !ProductStatusHandler.getAllVoidStatuses().contains(productStatus);
        }
        return false;
    }
}

