/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist;

import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ReceiptsFromListHelper {
    private static final Collection<ProductStatus> STATUSES_TO_EXCLUDE = Arrays.asList(ProductStatus.REFUND, ProductStatus.EXCHANGE);

    public static boolean containsSuitableProducts(List<?> selectedItems, List<TravelSubject> subjects) {
        for (Object item : selectedItems) {
            if (!(item instanceof CommonProductIndex) || !subjects.contains(((CommonProductIndex)item).getTravelSubject()) || STATUSES_TO_EXCLUDE.contains(((CommonProductIndex)item).getStatus()) || ProductStatusHandler.getAllVoidStatuses().contains(((CommonProductIndex)item).getStatus())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnlyAirOrRail(List<?> selectedItems) {
        boolean containsAvia = false;
        boolean containsRail = false;
        for (Object item : selectedItems) {
            if (!(item instanceof CommonProductIndex)) continue;
            TravelSubject travelSubject = ((CommonProductIndex)item).getTravelSubject();
            if (TravelSubject.AIR == travelSubject) {
                containsAvia = true;
            }
            if (TravelSubject.RAILWAY != travelSubject) continue;
            containsRail = true;
        }
        return containsAvia != containsRail;
    }
}

