/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.filters;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.Pane;

abstract class BaseProfileFilterFactory
implements ListPaneFilterFactory {
    BaseProfileFilterFactory() {
    }

    protected abstract OrganizationType getOrganizationType();

    public boolean isApplicableTo(TableColumnSettings settings) {
        return false;
    }

    public FilterHandler createFor(final TableColumnSettings settings, final Supplier<List<?>> itemsSupplier) throws Exception {
        return new FilterHandler(){
            private EntityBoxWidget<Organization> control;

            public void reset() {
                this.control.setValue(null);
            }

            public List<Object> getData() {
                if (this.control.getValue() != null) {
                    return Collections.singletonList(this.control.getValue());
                }
                return null;
            }

            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setValue((EntityReference)value.get(0));
                }
            }

            public void build(Pane pane) {
                this.control = new EntityBoxWidget(Organization.class, false);
                if (itemsSupplier != null) {
                    this.control.setItemsSupplier(itemsSupplier, true);
                } else {
                    this.control.setListParametersSupplier(this::getListParameters);
                }
                this.control.setFieldName(settings.getDisplayName());
                FilterHandler.buildFilter((Pane)pane, (String)settings.getDisplayName(), this.control);
            }

            private IndexListParameters<Organization, OrganizationIndex> getListParameters() {
                IndexListParameters result = new IndexListParameters();
                result.setIndexType(OrganizationIndex.class);
                result.getSearchCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.disabled.name(), (Object)Boolean.TRUE));
                result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)BaseProfileFilterFactory.this.getOrganizationType()));
                ListParametersHelper.setColumns(result, OrganizationIndex.Property.code.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.types.name());
                result.getSortings().put(OrganizationIndex.Property.name.name(), SortOrder.ASC);
                return result;
            }
        };
    }
}

