/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.AttachmentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.MailDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.model.AttachmentContainerVM;
import com.gridnine.xtrip.client.fx.standard.model.MailDocumentContainer;
import com.gridnine.xtrip.client.fx.standard.model.MailDocumentContainerController;
import com.gridnine.xtrip.client.fx.standard.model.MailDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.model.mail.MailAddressVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class MailDocumentHandler
extends BaseRootEntityHandler<MailDocument, Void, MailDocumentContainerVM, MailDocumentContainer> {
    public String format(EntityContainer<MailDocument> ctr) {
        return TextUtil.isBlank((String)((MailDocument)ctr.getEntity()).getName()) ? ((MailDocument)ctr.getEntity()).getTitle() : ((MailDocument)ctr.getEntity()).getName();
    }

    public Class<MailDocument> getEntityClass() {
        return MailDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<MailDocument, Void>, MailDocumentContainerVM>> toVM, List<BiConsumer<MailDocumentContainerVM, DataTransferPackage<MailDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new MailDocumentContainerControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new AttachmentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            MailDocument model = (MailDocument)dtp.getContainer().getEntity();
            vm.getMainSpecifications().setTitle(model.getTitle());
            vm.setDescription(model.getDescription());
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
            vm.getMainSpecifications().setOwner(model.getOwner());
            vm.getMainSpecifications().setFrom(model.getFrom() == null ? null : model.getFrom().getAddress());
            vm.getMainSpecifications().setSubject(model.getSubject());
            VMHelper.transfer(model.getTo(), vm.getMainSpecifications().getTo(), mailModel -> {
                MailAddressVM result = new MailAddressVM();
                result.setName(mailModel.getName());
                result.setAddress(mailModel.getAddress());
                return result;
            });
            VMHelper.transfer(model.getCc(), vm.getMainSpecifications().getCc(), mailModel -> {
                MailAddressVM result = new MailAddressVM();
                result.setNameAddress(this.getNameAddressFromModel((MailAddress)mailModel));
                return result;
            });
            VMHelper.transfer(model.getAttachments(), vm.getAttachments(), contentModel -> {
                AttachmentContainerVM result = new AttachmentContainerVM();
                result.setName(contentModel.getName());
                RichData data = new RichData();
                data.setContent(contentModel.getData());
                data.setContentType(contentModel.getContentType());
                result.setContent(data);
                return result;
            });
            RichData data = new RichData();
            data.setContent(model.getBody().getData());
            data.setContentType(model.getBody().getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setBody(data);
        });
        fromVM.add((vm, dtp) -> {
            MailDocument model = (MailDocument)dtp.getContainer().getEntity();
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setDescription(vm.getDescription());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
            model.setOwner(vm.getMainSpecifications().getOwner());
            model.setSubject(vm.getMainSpecifications().getSubject());
            VMHelper.transfer(vm.getAttachments(), model.getAttachments(), mailModel -> {
                MailPart result = new MailPart();
                result.setName(mailModel.getName());
                result.setContentType(mailModel.getContent() == null ? null : mailModel.getContent().getContentType());
                result.setData(mailModel.getContent() == null ? null : mailModel.getContent().getContent());
                return result;
            });
            model.setContent(vm.getBody() == null ? null : vm.getBody().getContent());
            model.setContentType(vm.getBody() == null ? null : vm.getBody().getContentType());
            model.getTo().clear();
            vm.getMainSpecifications().getTo().forEach(mailVM -> {
                MailAddress mailAddress = new MailAddress();
                mailAddress.setAddress(mailVM.getAddress());
                mailAddress.setName(mailVM.getName());
                model.getTo().add(mailAddress);
            });
        });
    }

    private String getNameAddressFromModel(MailAddress model) {
        if (model.getAddress() == null & model.getName() == null) {
            return null;
        }
        if (model.getName() == null) {
            return model.getAddress();
        }
        return model.getName() + " <" + model.getAddress() + ">";
    }

    @Override
    protected ViewController<MailDocumentContainer, MailDocumentContainerVM> createSpaceController(boolean readonly) {
        return new MailDocumentContainerController(readonly);
    }

    @Override
    protected MailDocumentContainerVM createVM() {
        return new MailDocumentContainerVM();
    }
}

