/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileComments;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFop;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopAdditional;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard1Grid;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCards;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainer;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullGdsNameInfo;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeDataSource;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RollbackVersionsSettings;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class BookingFileEditorInterceptor
implements RootEntityEditorInterceptor<BookingFile, BookingFileUIData> {
    public void beforeLoad(DataTransferPackage<BookingFile, BookingFileUIData> data) {
        boolean needReloadPrefetched = BookingHelper.getProducts((BookingFile)((BookingFile)data.getContainer().getEntity())).stream().anyMatch(product -> ProductFXHandler.forProduct(product).isNeedReloadPrefetched((BaseProduct)product));
        if (needReloadPrefetched) {
            try {
                Prefetched.load();
            }
            catch (Throwable e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }

    public void onLoad(DataTransferPackage<BookingFile, BookingFileUIData> data, Node editor) {
        RootEntityPane rootEntityPane;
        RollbackVersionsSettings rollbackVersionsSettings = Prefetched.getData().getRollbackVersionsSettings();
        if (rollbackVersionsSettings != null && rollbackVersionsSettings.isDisableBookingFileVersionsRollback() && ((BookingFileUIData)data.getSupplement()).isHasRelatedShipment() && (rootEntityPane = RootEntityPane.lookup((Node)editor)) != null) {
            BookingFileSpace space = (BookingFileSpace)editor;
            if (rootEntityPane.getMode() == EditingMode.EDIT) {
                FxUtil.submitToFxThread(() -> space.setMessages(Collections.singletonList(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BookingFileEditorInterceptor_booking_has_related_shipment, (Object[])new Object[0]))));
            }
            if (!rootEntityPane.isLastVersion()) {
                FxUtil.submitToFxThread(() -> space.setMessages(Collections.singletonList(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BookingFileEditorInterceptor_version_has_related_shipment, (Object[])new Object[0]))));
            }
        }
    }

    public boolean onSave(DataTransferPackage<BookingFile, BookingFileUIData> data, Node editor) {
        try {
            BookingFileSpace space = (BookingFileSpace)editor;
            ArrayList<Message> messages = new ArrayList<Message>();
            ((CompactNavigatorWidget)((BookingFileProductsFullPanel)space.getProductsTile().getFullNode()).getContent()).getViews().parallelStream().forEach(node -> {
                try {
                    ProductFXHandler.validateProductNode(space, (String)node.getProperties().get((Object)"model-uid"), node, messages);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            });
            if (((BookingFileComments)((BookingFileSpace)editor).getCommentsTile().getFullNode()).getCommentsNode().getValue() != null && ((BookingFileComments)((BookingFileSpace)editor).getCommentsTile().getFullNode()).getCommentsNode().getValue().length() > 255) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BookingFileEditorInterceptor_comment_too_long, (Object[])new Object[0]));
            }
            Set<EntityReference<Organization>> newPayers = this.getNewPayers(space);
            EntityReference newClient = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)space.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
            EntityReference oldClient = ((BookingFile)data.getContainer().getEntity()).getCustomerProfile();
            if (!newPayers.isEmpty() && newClient != null && oldClient != null && (!newClient.equals((Object)oldClient) && ((BookingFileUIData)data.getSupplement()).isHasNonStandardPayer() || newClient.equals((Object)oldClient) && newPayers.stream().anyMatch(newPayer -> !MiscUtil.equals((Object)newPayer, (Object)newClient)) || !newClient.equals((Object)oldClient) && !((BookingFileUIData)data.getSupplement()).isHasNonStandardPayer() && newPayers.stream().anyMatch(newPayer -> !MiscUtil.equals((Object)newPayer, (Object)oldClient)))) {
                Message message = MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BookingFileEditorInterceptor_client_change_with_non_standard_payer, (Object[])new Object[0]);
                messages.add(message);
            }
            BookingFile bookingFile = (BookingFile)data.getContainer().getEntity();
            ObservableList reservationsFullCtrs = ((PlainGroupsWidget)((BookingFileReservationsFullPanel)space.getReservationsTile().getFullNode()).getContent()).getViews();
            for (BookingFileReservationsFullContainer ctr : reservationsFullCtrs) {
                GdsName newStatGdsName = (GdsName)((BookingFileReservationsFullGdsNameInfo)ctr.getGdsNameInfoCard().getContent()).getStatisticsGdsNameNode().getValue();
                if (newStatGdsName != null) continue;
                List productUids = ((TableWidget)ctr.getProductsCard().getContent()).getRowsData().stream().map(BookingFileReservationsFullProductsVM::getProductUID).collect(Collectors.toList());
                block3: for (Reservation reservation : bookingFile.getReservations()) {
                    BaseProduct product;
                    GdsName oldStatGdsName = reservation.getGdsNameInfo().getStatisticsGdsName();
                    if (oldStatGdsName == null) continue;
                    Iterator iterator = reservation.getProducts().iterator();
                    while (iterator.hasNext() && productUids.contains((product = (BaseProduct)iterator.next()).getUid())) {
                        if (!product.getBillingDataChangeEntries().isEmpty() && !product.getBillingDataChangeEntries().stream().anyMatch(e -> e.getSource() != ProductBillingDataChangeDataSource.CLIENT)) continue;
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BookingFileEditorInterceptor_statistics_GdsName_cleared, (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
                        continue block3;
                    }
                }
            }
            if (!messages.isEmpty()) {
                FxUtil.submitToFxThread(() -> space.setMessages((List)messages));
                return messages.stream().noneMatch(it -> it.getType() == MessageType.ERROR);
            }
            return true;
        }
        catch (Exception e2) {
            ErrorHandler.handle((Throwable)e2);
            return false;
        }
    }

    private Set<EntityReference<Organization>> getNewPayers(BookingFileSpace space) {
        HashSet<EntityReference<Organization>> result = new HashSet<EntityReference<Organization>>();
        CompactNavigatorWidget content = (CompactNavigatorWidget)((BookingFileProductsFullPanel)space.getProductsTile().getFullNode()).getContent();
        for (Node node : content.getViews()) {
            GridCell<BookingFileProductFop> fopsCell = this.getFopsCell(node);
            if (fopsCell == null) continue;
            ExtendedTableWidget payload = (ExtendedTableWidget)((BookingFileProductFop)fopsCell.getPayload()).getFopTableCell().getPayload();
            List rows = payload.getTable().getRows();
            for (ExtendedTableWidget.Row row : rows) {
                ContractType contractType = (ContractType)((ComboBoxWidget)row.getWidget("contractType")).getValue();
                if (contractType != ContractType.CLIENT) continue;
                BookingFileProductFopCards fopCards = (BookingFileProductFopCards)((BookingFileProductFopAdditional)((PopupWidget)row.getWidget("superColumn")).getView()).getContent();
                for (Card card : fopCards.getCards()) {
                    GridCell payerCell;
                    BookingFileProductFopCard1Grid fopContent;
                    ObservableList cells;
                    Node cardContent = card.getContent();
                    if (!(cardContent instanceof BookingFileProductFopCard1Grid) || !CollectionUtil.isNotEmpty((Collection)(cells = (fopContent = (BookingFileProductFopCard1Grid)cardContent).getCells())) || !(payerCell = (GridCell)cells.get(0)).getCaption().equals("\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a")) continue;
                    EntityBoxWidget payerWidget = (EntityBoxWidget)payerCell.getPayload();
                    EntityReference newPayer = payerWidget.getValue();
                    result.add((EntityReference<Organization>)newPayer);
                }
            }
        }
        return result;
    }

    private GridCell<BookingFileProductFop> getFopsCell(Node node) {
        if (node instanceof BookingFileProductAirPanel) {
            BookingFileProductAirPanel panel = (BookingFileProductAirPanel)node;
            return panel.getFopsCell();
        }
        if (node instanceof BookingFileProductRailwayPanel) {
            BookingFileProductRailwayPanel panel = (BookingFileProductRailwayPanel)node;
            return panel.getFopsCell();
        }
        if (node instanceof BookingFileProductHotelPanel) {
            BookingFileProductHotelPanel panel = (BookingFileProductHotelPanel)node;
            return panel.getFopsCell();
        }
        if (node instanceof BookingFileProductTransferXtripPanel) {
            BookingFileProductTransferXtripPanel panel = (BookingFileProductTransferXtripPanel)node;
            return panel.getFopsCell();
        }
        return null;
    }
}

