/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CommunicationFilter {
    private final List<Communication> web = new ArrayList<Communication>();
    private final List<Communication> phone = new ArrayList<Communication>();

    public CommunicationFilter(List<Communication> model) {
        this.filter(model);
    }

    private void filter(List<Communication> model) {
        EnumSet<CommunicationType[]> phoneTypes = EnumSet.of(CommunicationType.HOME_PHONE, new CommunicationType[]{CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.FAX, CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL});
        model.forEach(com -> {
            if (com.getType() == null && !TextUtil.isBlank((String)com.getSense())) {
                com.setType(CommunicationType.WORK_PHONE);
                this.phone.add((Communication)com);
            } else if (phoneTypes.contains(com.getType())) {
                this.phone.add((Communication)com);
            } else {
                this.web.add((Communication)com);
            }
        });
    }

    public List<Communication> getWeb() {
        return new ArrayList<Communication>(this.web);
    }

    public List<Communication> getPhone() {
        return new ArrayList<Communication>(this.phone);
    }
}

