/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileDetailedServicesTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsOverviewCardsVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public final class OverviewTileHelper {
    static void toVM(BookingFile model, BookingFileProductsOverviewCardsVM full, BookingFileUIData uiData) {
        full.getOverviewPanel().setBookingNumber(model.getNumber());
        full.getOverviewPanel().setAgency(model.getAgency());
        full.getOverviewPanel().setClient(model.getCustomerProfile());
        full.getOverviewPanel().setProductsCount(model.getReservations().stream().mapToInt(reservation -> reservation.getProducts().size()).sum());
        full.getOverviewPanel().setTravellersCount(OverviewTileHelper.calcUniqueTravellersCount(model.getTravellers()));
        MiscUtil.Value total = new MiscUtil.Value((Object)BigDecimal.ZERO);
        MiscUtil.Value toPayTotal = new MiscUtil.Value((Object)BigDecimal.ZERO);
        MiscUtil.Value includingFeesTotal = new MiscUtil.Value((Object)BigDecimal.ZERO);
        VMHelper.transfer(uiData.getDetailsPriceUIData(), full.getOrderDetailing().getDetailedServicesTable(), el -> {
            BookingFileDetailedServicesTableVM vm = new BookingFileDetailedServicesTableVM();
            vm.setDiscount((String)StandardRenderers.PRICE.apply((Object)el.getDiscount()));
            vm.setFee((String)StandardRenderers.PRICE.apply((Object)el.getFee()));
            vm.setName(el.getName());
            vm.setPay((String)StandardRenderers.PRICE.apply((Object)el.getPay()));
            vm.setPrice((String)StandardRenderers.PRICE.apply((Object)el.getPrice()));
            vm.setTotal((String)StandardRenderers.PRICE.apply((Object)el.getTotal()));
            vm.setProductUid(el.getUidProduct());
            vm.setNavigate(Messages.overviewTileHelper_goTo);
            total.setValue((Object)((BigDecimal)total.getValue()).add(el.getTotal().setScale(2, 4)));
            toPayTotal.setValue((Object)((BigDecimal)toPayTotal.getValue()).add(el.getPay().setScale(2, 4)));
            includingFeesTotal.setValue((Object)((BigDecimal)includingFeesTotal.getValue()).add(el.getFee().setScale(2, 4)));
            return vm;
        });
        full.getOrderDetailing().setTotal((BigDecimal)total.getValue());
        full.getOrderDetailing().setToPayTotal((BigDecimal)toPayTotal.getValue());
        full.getOrderDetailing().setIncludingFeesTotal((BigDecimal)includingFeesTotal.getValue());
    }

    public static int calcUniqueTravellersCount(List<Traveller> travellers) {
        if (CollectionUtil.isEmpty(travellers)) {
            return 0;
        }
        long personCount = travellers.stream().map(Traveller::getPassenger).filter(Objects::nonNull).distinct().count();
        long withoutPersonCount = travellers.stream().filter(tr -> tr.getPassenger() == null).count();
        return (int)(personCount + withoutPersonCount);
    }

    private OverviewTileHelper() {
    }
}

