/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStubParentVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.system.BaseVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.ReservationsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DetailsPriceUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class ProductsTileHelper {
    static void toVM(BookingFile bookingFile, BookingFileUIData uiData, BookingFileProductsFullPanelVM vm) {
        List products = bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap positions = new HashMap();
        ArrayList<BaseProductVM> productVms = new ArrayList<BaseProductVM>(products.size());
        VMHelper.transfer(products, productVms, product -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(product);
            return handler == null ? new BookingFileProductStubParentVM() : handler.createVM((BaseProduct)product);
        }, (product, productVM) -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(product);
            if (handler == null) {
                BookingFileProductStubParentVM stubVM = (BookingFileProductStubParentVM)productVM;
                stubVM.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
                stubVM.getMain().setMain(Messages.Viewing_Editing_Not_Supported);
            } else {
                BaseProductUIData productUiData = null;
                for (BaseProductUIData data : uiData.getProducts()) {
                    if (!data.getRelatedProductUID().equals(product.getUid())) continue;
                    productUiData = data;
                    break;
                }
                if (productUiData == null) {
                    productUiData = (BaseProductUIData)handler.createUiData();
                }
                productVM.setProductUiData(productUiData);
                handler.toVM((BaseProduct)product, productUiData, (BaseProductVM)productVM, (EntityReference<Organization>)bookingFile.getCustomerProfile());
            }
            productVM.setBookingFile(bookingFile);
            DetailsPriceUIData detailsPriceUIData = uiData.getDetailsPriceUIData().stream().filter(dd -> product.getUid().equals(dd.getUidProduct())).findFirst().orElse(null);
            if (detailsPriceUIData != null) {
                productVM.setProductFullNameWithSpaces(detailsPriceUIData.getName());
                positions.put(productVM, uiData.getDetailsPriceUIData().indexOf(detailsPriceUIData));
            } else {
                productVM.setProductFullNameWithSpaces(productVM.getProductShortName());
                positions.put(productVM, -1);
            }
            if (productVM.getProductType() == null) {
                productVM.setProductType(BaseProduct.class);
            }
        });
        productVms.sort(Comparator.comparing(positions::get));
        vm.getContent().addAll(productVms);
    }

    static void fromVM(BookingFile bookingFile, BookingFileSpaceVM bookingFileSpaceVM, BookingFileUIData bookingFileSupplementData) {
        Map<String, BaseProduct> products = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toMap(BaseIdentity::getUid, item -> item));
        Map<String, BaseProductUIData> productSupplementDatas = bookingFileSupplementData.getProducts().stream().collect(Collectors.toMap(BaseProductUIData::getRelatedProductUID, item -> item));
        List productVMs = bookingFileSpaceVM.getProductsFull().getContent();
        ProductsTileHelper.removeProducts(bookingFile, productVMs.stream().map(BaseVM::getUid).collect(Collectors.toSet()));
        for (BaseProductVM productVM : productVMs) {
            ProductFXHandler<Object, ?, ?, ?> handler;
            Object product = products.get(productVM.getUid());
            Object productSupplementData = productSupplementDatas.get(productVM.getUid());
            if (product != null) {
                handler = ProductFXHandler.forProduct(product);
                if (!TextUtil.isSame((String)product.getReservation().getUid(), (String)handler.getRecordLocator(productVM))) {
                    product.getReservation().getProducts().remove(product);
                    product.setReservation(null);
                }
            } else {
                handler = ProductFXHandler.forProductClass(productVM.getProductType());
                product = handler.createProduct();
                product.setUid(productVM.getUid());
                if (productSupplementData == null) {
                    productSupplementData = handler.createUiData();
                    productSupplementData.setRelatedProductUID(productVM.getUid());
                    bookingFileSupplementData.getProducts().add(productSupplementData);
                }
            }
            if (product.getReservation() == null) {
                String reservationUid = handler.getRecordLocator(productVM);
                Reservation reservation = bookingFile.getReservations().stream().filter(item -> item.getUid().equals(reservationUid)).findFirst().orElse(null);
                if (reservation == null) {
                    reservation = new Reservation();
                    bookingFile.getReservations().add(reservation);
                    reservation.setBookingFile(bookingFile);
                    reservation.setUid(reservationUid);
                    BookingFileReservationsFullContainerVM reservationVm = new BookingFileReservationsFullContainerVM();
                    reservationVm.setUid(reservationUid);
                    ReservationsTileHelper.addProduct(product, reservationVm);
                    bookingFileSpaceVM.getReservationsFull().getContent().add(reservationVm);
                }
                reservation.getProducts().add(product);
                product.setReservation(reservation);
            }
            handler.fromVM(productVM, product, productSupplementData);
        }
        bookingFile.getReservations().removeIf(item -> item.getProducts().isEmpty());
    }

    private static void removeProducts(BookingFile bookingFile, Set<String> existingProductUids) {
        Set products = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> !existingProductUids.contains(item.getUid())).collect(Collectors.toSet());
        for (BaseProduct product : products) {
            ProductFXHandler.forProduct(product).remove(product);
        }
    }

    private ProductsTileHelper() {
    }
}

