/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravellerContactsEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.CommunicationFilter;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Communication;
import java.util.List;

final class TravellersHelper {
    static void toVM(BookingFileTravelersPanelVM travelers) {
        for (BookingFileTravelerPanelVM travelerVM : travelers.getContent()) {
            Traveller traveller = travelerVM.getGeneralParameters().getTraveller();
            CommunicationFilter filtered = new CommunicationFilter(traveller.getCommunications());
            List<Communication> web = filtered.getWeb();
            List<Communication> phone = filtered.getPhone();
            VMHelper.transfer(web, travelerVM.getCommunications().getEmails(), res -> new BookingFileTravellerContactsEmailVM(), (mod, modVM) -> {
                modVM.setAddress(mod.getSense());
                modVM.setNotes(mod.getRemarks());
                modVM.setType(mod.getType());
            });
            VMHelper.transfer(phone, travelerVM.getCommunications().getPhones(), res -> new ContactPhonesTableVM(), (mod, modVM) -> {
                modVM.setCityCode(mod.getCityCode());
                modVM.setCountryCode(mod.getCountryCode());
                modVM.setInternalNumber(mod.getInternalNumber());
                modVM.setPhoneNumber(mod.getSense());
                modVM.setNotes(mod.getRemarks());
                modVM.setType(mod.getType());
            });
        }
    }

    static void fromVM(BookingFileTravelersPanelVM travelers) {
        for (BookingFileTravelerPanelVM travelerVM : travelers.getContent()) {
            Traveller traveller = travelerVM.getGeneralParameters().getTraveller();
            CommunicationFilter filtered = new CommunicationFilter(traveller.getCommunications());
            List<Communication> web = filtered.getWeb();
            List<Communication> phone = filtered.getPhone();
            VMHelper.transfer(travelerVM.getCommunications().getEmails(), web, res -> new Communication(), (modVM, mod) -> {
                mod.setSense(modVM.getAddress());
                mod.setRemarks(modVM.getNotes());
                mod.setType(modVM.getType());
            });
            VMHelper.transfer(travelerVM.getCommunications().getPhones(), phone, res -> new Communication(), (modVM, mod) -> {
                mod.setCityCode(modVM.getCityCode());
                mod.setCountryCode(modVM.getCountryCode());
                mod.setInternalNumber(modVM.getInternalNumber());
                mod.setSense(modVM.getPhoneNumber());
                mod.setRemarks(modVM.getNotes());
                mod.setType(modVM.getType());
            });
            traveller.getCommunications().clear();
            traveller.getCommunications().addAll(web);
            traveller.getCommunications().addAll(phone);
        }
    }

    private TravellersHelper() {
    }
}

