/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ChangePayerProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CommonRefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ExchangeProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnvoidProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VoidProductAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductExchangeTask;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;

public class AeroexpressProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-aeroexpress-product-actions-provider";
    }

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductAeroexpressPanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<AeroexpressTicket>(){

            @Override
            protected BaseProduct getPreviousProduct(AeroexpressTicket product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<AeroexpressTicket>(){

            @Override
            protected BaseProduct getNextProduct(AeroexpressTicket product) {
                return product.getNextProduct();
            }
        }, new ExchangeProductAction<AeroexpressTicket>(){

            @Override
            protected boolean isEnabled(AeroexpressTicket product) {
                return product != null && product.getStatus() == ProductStatus.BOOKING && product.getNextProduct() == null;
            }

            @Override
            protected void execute(ProductActionContext<AeroexpressTicket> ctx) {
                Dialog.confirm(ctx.getRootPane(), (String)Messages.Exchange_the_selected_product, () -> {
                    ProductExchangeRefundProperties props = new ProductExchangeRefundProperties(null, null, false, null, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
                    Notifications.get().enqueueAsyncTask((ClientTask)new ProductExchangeTask(((AeroexpressTicket)ctx.getSelectedProduct()).getUid(), props, ctx.getRootPane()));
                });
            }
        }, new CommonRefundProductAction(), new RecalculateFOPProductAction(), new CopyProductAction<AeroexpressTicket>(){

            @Override
            protected boolean isEnabled(AeroexpressTicket product) {
                return product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus());
            }

            @Override
            protected void execute(ProductActionContext<AeroexpressTicket> ctx) {
                CopyTask.showCopyDialog((EntityReference<BookingFile>)ctx.getRootPane().getData().getContainer().toReference(), ctx.getSelectedProduct().getUid(), ctx.getRootPane(), ctx.getRootPane().getMutex());
            }
        }, new VoidProductAction<AeroexpressTicket>(){

            @Override
            protected boolean isEnabled(AeroexpressTicket product) {
                return product != null && (product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.SELL) && product.getNextProduct() == null;
            }
        }, new UnvoidProductAction<AeroexpressTicket>(){

            @Override
            protected boolean isEnabled(AeroexpressTicket product) {
                return product != null && (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING);
            }
        }, new PayProductAction<AeroexpressTicket>(){

            @Override
            protected ProductStatus getStatus(AeroexpressTicket product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<AeroexpressTicket>(){

            @Override
            protected ProductStatus getStatus(AeroexpressTicket product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<AeroexpressTicket>(){

            @Override
            protected ProductStatus getStatus(AeroexpressTicket product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<AeroexpressTicket>(){

            @Override
            protected ProductStatus getStatus(AeroexpressTicket product) {
                return product.getStatus();
            }
        }, new ChangePayerProductAction());
        return this.actions;
    }
}

