/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.AirProductFopMapActionDialog;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class AirProductFopMapAction
implements TileAction<Node, BookingFileProductsFullPanel> {
    public String getName(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Fop_map_action;
    }

    public String getDescription(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Fop_map_action;
    }

    public double getWeight() {
        return 25.0;
    }

    public boolean isEnabled(Tile<Node, BookingFileProductsFullPanel> tile) {
        if (((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getViewState().isImmutable()) {
            return false;
        }
        RootEntityPane rep = RootEntityPane.lookup((Node)tile.getFullNode());
        if (rep == null || rep.getData() == null) {
            return false;
        }
        String uidProduct = (String)((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getSelectedView().getProperties().get((Object)"model-uid");
        if (uidProduct == null) {
            return false;
        }
        AirProductUIData uidataProduct = ((BookingFileUIData)rep.getData().getSupplement()).getProducts().stream().filter(baseProductUIData -> uidProduct.equals(baseProductUIData.getRelatedProductUID())).findFirst().orElse(null);
        return uidataProduct != null && uidataProduct.isTCHTicket();
    }

    public void execute(Control source, Tile<Node, BookingFileProductsFullPanel> tile, boolean alt) {
        RootEntityPane rootPane = RootEntityPane.lookup((Node)source);
        if (!rootPane.isDataChanged()) {
            Product product = (Product)ProductActionsHelper.getSelectedProduct(tile);
            if (product != null) {
                AirProductFopMapActionDialog dialog = new AirProductFopMapActionDialog();
                dialog.executeAfterSaveRequired(product, source, tile, alt);
            }
            return;
        }
        new Dialog().setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).setMessage(Messages.Save_changes).setSupplmentalMessage(null).setOnCloseRequest(null).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.Dont_save_and_continue, () -> {
            if (!rootPane.validate()) {
                return;
            }
            Product product = (Product)ProductActionsHelper.getSelectedProduct(tile);
            if (product == null) {
                return;
            }
            AirProductFopMapActionDialog dialog = new AirProductFopMapActionDialog();
            dialog.executeAfterSaveRequired(product, source, tile, alt);
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Save_and_continue, () -> {
            if (!rootPane.validate()) {
                return;
            }
            Notifications.get().submitTask(() -> {
                rootPane.saveData();
                FxUtil.submitToFxThread(() -> {
                    Product product = (Product)ProductActionsHelper.getSelectedProduct(tile);
                    if (product == null) {
                        return;
                    }
                    if (this.isEnabled(tile)) {
                        AirProductFopMapActionDialog dialog = new AirProductFopMapActionDialog();
                        dialog.executeAfterSaveRequired(product, source, tile, alt);
                    }
                });
            }, rootPane.getMutex());
        }).showGlobal();
    }
}

