/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import javafx.scene.Node;
import javafx.scene.control.Control;

public abstract class BaseProductAction<P extends BaseProduct>
implements TileAction<Node, BookingFileProductsFullPanel> {
    public final String getName(Tile<Node, BookingFileProductsFullPanel> tile) {
        return this.getName();
    }

    public final String getDescription(Tile<Node, BookingFileProductsFullPanel> tile) {
        return this.getDescription();
    }

    public final boolean isEnabled(Tile<Node, BookingFileProductsFullPanel> tile) {
        if (((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getViewState().isImmutable()) {
            return false;
        }
        BaseProduct selectedProduct = ProductActionsHelper.getSelectedProduct(tile);
        return selectedProduct != null && this.isEnabled(selectedProduct);
    }

    public final void execute(Control source, Tile<Node, BookingFileProductsFullPanel> tile, boolean alt) {
        RootEntityPane rootPane = RootEntityPane.lookup((Node)source);
        if (!this.isSaveRequired() || !rootPane.isDataChanged()) {
            ProductActionContext ctx = new ProductActionContext(tile, alt, rootPane);
            if (ctx.getSelectedProduct() != null) {
                this.execute(ctx);
            }
            return;
        }
        new Dialog().setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).setMessage(Messages.Save_changes).setSupplmentalMessage(null).setOnCloseRequest(null).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.Dont_save_and_continue, () -> {
            if (!rootPane.validate()) {
                return;
            }
            ProductActionContext ctx = new ProductActionContext(tile, alt, rootPane);
            Object selectedProduct = ctx.getSelectedProduct();
            if (selectedProduct == null) {
                return;
            }
            this.execute(ctx);
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Save_and_continue, () -> {
            if (!rootPane.validate()) {
                return;
            }
            Notifications.get().submitTask(() -> {
                rootPane.saveData();
                FxUtil.submitToFxThread(() -> {
                    ProductActionContext ctx = new ProductActionContext(tile, alt, rootPane);
                    Object selectedProduct = ctx.getSelectedProduct();
                    if (selectedProduct == null) {
                        return;
                    }
                    if (this.isEnabled(selectedProduct)) {
                        this.execute(ctx);
                    }
                });
            }, rootPane.getMutex());
        }).showGlobal();
    }

    public final AclQuery getACLQuery(Tile<Node, BookingFileProductsFullPanel> tile) {
        EntityContainer<BookingFile> bookingFile = ProductActionsHelper.getBookingFile(tile);
        BaseProduct selectedProduct = ProductActionsHelper.getSelectedProduct(tile);
        return this.getACLQuery(bookingFile, selectedProduct);
    }

    protected abstract String getName();

    protected abstract String getDescription();

    protected abstract boolean isEnabled(P var1);

    protected abstract boolean isSaveRequired();

    protected abstract void execute(ProductActionContext<P> var1);

    protected AclQuery getACLQuery(EntityContainer<BookingFile> bookingFile, P product) {
        return null;
    }
}

