/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSettings;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class BaseProductCreatePassiveSegmentsActionsProvider<P extends BaseProduct>
extends BaseProductAction<P> {
    @Override
    protected String getName() {
        return Messages.CreatePassiveSegments;
    }

    @Override
    protected String getDescription() {
        return Messages.CreatePassiveSegments;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected void execute(ProductActionContext<P> ctx) {
        if (!Prefetched.getData().isSabrePassiveSegmentsSettingsEnabled()) {
            Notifications.get().showStaticNotification(Messages.SabrePassiveSegmentsSettingsNotEnabled, "");
            return;
        }
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        for (Reservation res : ((BookingFile)ctx.getRootPane().getData().getContainer().getEntity()).getReservations()) {
            if (CommonReservationGdsNameInfoHelper.containsGds((Reservation)res, (GdsName)GdsName.SABRE)) continue;
            for (BaseProduct bp : res.getProducts()) {
                ProductPassiveSegmentsHandler handler = HandlersRegistry.get().findProductPassiveSegmentsHandler(bp.getClass());
                if (handler == null || !handler.isAcceptableForPassiveSegmentsCreation(bp, new ArrayList())) continue;
                products.add(bp);
            }
        }
        if (products.isEmpty()) {
            Notifications.get().showStaticNotification(Messages.PassiveSegments_noAcceptableProductsFound, "");
            return;
        }
        SabrePassiveSegmentsSettings res = new SabrePassiveSegmentsSettings();
        Notifications.get().submitTask(() -> {
            List userSPSettings = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getSabreProfilesPccSettings(ServiceInvocationContext.get(), Prefetched.getData().getCurrentAgentData().getAgent());
            List allowedPCCs = userSPSettings.stream().map(el -> el.getPcc()).filter(pcc -> pcc != null).map(pcc -> pcc.toUpperCase()).collect(Collectors.toList());
            res.getAllowedPCCs().addAll(allowedPCCs);
            FxUtil.waitForFxThread(() -> this.createDialogForNextStep(ctx, res, products));
        }, Messages.Notifications_getting_settings);
    }

    private void createDialogForNextStep(ProductActionContext<P> ctx, SabrePassiveSegmentsSettings res, List<BaseProduct> products) {
        LinkedHashMap productSelected = new LinkedHashMap();
        final TableWidget<ProductTableVM> productsWidget = this.createProductsWidget();
        productsWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                TableWidgetColumn checkedWidget = productsWidget.getColumn("checked");
                ((BooleanValueWidget)((BooleanValueWidgetColumn)checkedWidget).getWidget(idx)).valueProperty().addListener((val, oldVal, newVal) -> {
                    String uid = ((ProductTableVM)productsWidget.getData(idx)).getProductUID();
                    for (Map.Entry entry : productSelected.entrySet()) {
                        if (!((BaseProduct)entry.getKey()).getUid().equals(uid)) continue;
                        entry.setValue((Boolean)newVal);
                    }
                });
            }
        });
        TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM> productsController = new TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM>(){

            public TableWidget<ProductTableVM> getView() {
                return productsWidget;
            }
        };
        HashMap<BaseProduct, Boolean> productsToProcess = new HashMap<BaseProduct, Boolean>();
        for (BaseProduct product : products) {
            productsToProcess.put(product, product.equals(ctx.getSelectedProduct()) ? Boolean.TRUE : Boolean.FALSE);
        }
        List<ProductTableVM> productsVM = this.configureProductTableVM(productsToProcess);
        productsController.readData(productsVM);
        CardsContainer cardsContainer = this.createParametersCard(productsWidget, ctx.getSelectedProduct().getPassiveSegmentsCreationResult() != null ? ctx.getSelectedProduct().getPassiveSegmentsCreationResult().getPnr() : null);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.PassiveSegments_dialogTitle).setAutoClose(false).setExpandToParent(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> this.lambda$createDialogForNextStep$17(cardsContainer, res, (TableWidgetController)productsController, ctx, dialog)).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)ctx.getProductsWidget());
    }

    private void createPassiveSegments(EntityContainer<BookingFile> bfCont, SabrePassiveSegmentsSettings settings, List<Message> msgs) throws Exception {
        String bfCaption = bfCont != null && bfCont.toReference() != null ? bfCont.toReference().getCaption() : "";
        RpcServiceManager rpcServiceManager = RpcServiceManager.get();
        ServiceInvocationContext serviceInvocationContext = ServiceInvocationContext.get();
        EntityReference bfRef = bfCont.toReference();
        SabrePassiveSegmentsResult result = ((ModelService)rpcServiceManager.getService(ModelService.class)).createPassiveSegmentsInSabre(serviceInvocationContext, bfRef, settings, msgs);
        if ("SUCCESS".equals(result.getResponseType())) {
            msgs.add(MessageHelper.createMessage((String)Messages.PassiveSegments_resultSuccessfully, (Object[])new Object[]{bfCaption, result.getPnr()}));
        } else if ("WARNING".equals(result.getResponseType())) {
            msgs.add(MessageHelper.createMessage((String)Messages.PassiveSegments_resultWithWarnings, (Object[])new Object[]{bfCaption, result.getPnr()}));
        } else {
            msgs.add(MessageHelper.createMessage((String)Messages.PassiveSegments_resultWithErrors, (Object[])new Object[]{bfCaption}));
        }
        msgs.addAll(result.getMessages());
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bfCont.toReference(), EntityModification.ModificationType.CHANGE)));
    }

    private List<Message> validatePassiveSegmentsParameters(SabrePassiveSegmentsSettings settings, DataTransferPackage<BookingFile, ?> ctx, List<String> allowedPCCs) {
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        if (!settings.isNewReservation() && TextUtil.isBlank((String)settings.getPnr())) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_pnrNotSet, (Object[])new Object[0]));
        }
        if (settings.isNewReservation() && TextUtil.isBlank((String)settings.getPcc())) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_pccNotSet, (Object[])new Object[0]));
        }
        if (settings.isNewReservation() && !allowedPCCs.contains(settings.getPcc())) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_pccNotAllowed, (Object[])new Object[]{settings.getPcc()}));
        }
        if (!settings.isNewReservation() && allowedPCCs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_allowedPccsEmpty, (Object[])new Object[0]));
        }
        if (settings.getProductUids().isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_productsNotSet, (Object[])new Object[0]));
        }
        if (settings.isNewReservation() && ((BookingFileUIData)ctx.getSupplement()).isAgentPhonesIsEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PassiveSegments_AgentPhoneNotSet, (Object[])new Object[0]));
        }
        return validationErrors;
    }

    private List<ProductTableVM> configureProductTableVM(Map<BaseProduct, Boolean> products) {
        return products.entrySet().stream().map(item -> {
            BaseProduct baseProduct = (BaseProduct)item.getKey();
            Boolean checked = (Boolean)item.getValue();
            ProductTableVM productVM = new ProductTableVM();
            productVM.setProductName(BookingHelper.generateShortProductName((BaseProduct)baseProduct));
            productVM.setProductUID(baseProduct.getUid());
            productVM.setChecked(checked);
            return productVM;
        }).collect(Collectors.toList());
    }

    private TableWidget<ProductTableVM> createProductsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ProductTableVM::getProductName, ProductTableVM::setProductName);
        column.setId("product");
        column.setCaption("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        columns.add(column);
        column = new BooleanValueWidgetColumn(ProductTableVM::isChecked, ProductTableVM::setChecked);
        column.setId("checked");
        column.setCaption("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u0441\u0441\u0438\u0432\u043d\u044b\u0439 \u0441\u0435\u0433\u043c\u0435\u043d\u0442");
        column.setPrefWidth(Double.valueOf(30.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private CardsContainer createParametersCard(TableWidget<ProductTableVM> productsWidget, String pnr) {
        GridContainer productContainer = new GridContainer();
        productContainer.setColumnsCount(1);
        TextFieldWidget locatorNumberWidget = new TextFieldWidget(false);
        locatorNumberWidget.getViewState().setNotEditable(true);
        TextFieldWidget pccWidget = new TextFieldWidget(false);
        TextFieldWidget queueNumberWidget = new TextFieldWidget(false);
        BooleanValueWidget addToCurrentBookingFileWidget = new BooleanValueWidget(false, false);
        addToCurrentBookingFileWidget.setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean val) {
                return val != false ? Messages.PassiveSegments_add_booking_file_to_currentBF : Messages.PassiveSegments_add_booking_file_to_newBF;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        addToCurrentBookingFileWidget.valueProperty().addListener((obj, o, n) -> {
            pccWidget.getViewState().setNotEditable(n.booleanValue());
            pccWidget.setValue(null);
            locatorNumberWidget.getViewState().setNotEditable(n == false);
            locatorNumberWidget.setValue(null);
        });
        addToCurrentBookingFileWidget.setValue(true);
        locatorNumberWidget.setValue(pnr);
        productContainer.getCells().add((Object)new GridCell("", productsWidget));
        productContainer.getCells().add((Object)new GridCell(Messages.PassiveSegments_add_booking_file, (Node)addToCurrentBookingFileWidget));
        productContainer.getCells().add((Object)new GridCell(Messages.PassiveSegments_locator_number, (Node)locatorNumberWidget));
        productContainer.getCells().add((Object)new GridCell("PCC", (Node)pccWidget));
        productContainer.getCells().add((Object)new GridCell(Messages.PassiveSegments_queue_number, (Node)queueNumberWidget));
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Products, (Node)productContainer));
        return cardsContainer;
    }

    public double getWeight() {
        return 9000.0;
    }

    @Override
    protected AclQuery getACLQuery(EntityContainer<BookingFile> bookingFile, P product) {
        return new AclQuery(StandardRestrictionResourceOperations.EXPORT.getId(), ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
    }

    @Override
    protected boolean isEnabled(P product) {
        return true;
    }

    private /* synthetic */ void lambda$createDialogForNextStep$17(CardsContainer cardsContainer, SabrePassiveSegmentsSettings res, TableWidgetController productsController, ProductActionContext ctx, Dialog dialog) {
        Notifications.get().submitTask(() -> {
            List<Message> validationErrors;
            ObservableList cells = ((GridContainer)((Card)cardsContainer.getCards().get(0)).getContent()).getCells();
            res.setPnr(((TextFieldWidget)((GridCell)cells.get(2)).getPayload()).getValue());
            res.getProductUids().clear();
            ArrayList productsTableVM = new ArrayList();
            productsController.writeData(productsTableVM);
            res.getProductUids().addAll(productsTableVM.stream().filter(ProductTableVM::isChecked).map(ProductTableVM::getProductUID).collect(Collectors.toList()));
            if (!TextUtil.isBlank((String)((TextFieldWidget)((GridCell)cells.get(3)).getPayload()).getValue())) {
                res.setPcc(((TextFieldWidget)((GridCell)cells.get(3)).getPayload()).getValue().toUpperCase());
            } else {
                res.setPcc(null);
            }
            if (!TextUtil.isBlank((String)((TextFieldWidget)((GridCell)cells.get(4)).getPayload()).getValue())) {
                res.setQueue(((TextFieldWidget)((GridCell)cells.get(4)).getPayload()).getValue());
            } else {
                res.setQueue(null);
            }
            res.setNewReservation(!((BooleanValueWidget)((GridCell)cells.get(1)).getPayload()).getValue());
            if (res.getPnr() != null) {
                res.setPnr(res.getPnr().toUpperCase());
            }
            if (!(validationErrors = this.validatePassiveSegmentsParameters(res, ctx.getRootPane().getData(), res.getAllowedPCCs())).isEmpty()) {
                Notifications.get().showMessages(validationErrors);
                return;
            }
            List result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).validatePassiveSegmentsParameters(ServiceInvocationContext.get(), ctx.getRootPane().getData().getContainer().toReference(), res);
            if (!result.isEmpty()) {
                Notifications.get().showMessages((Collection)result);
                return;
            }
            String dupe1Msg = "";
            String dupe2Msg = "";
            String confirmMsg = "";
            Set pnrList = ((BookingFile)ctx.getRootPane().getData().getContainer().getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> res.getProductUids().contains(p.getUid()) && p.getPassiveSegmentsCreationResult() != null && !TextUtil.isBlank((String)p.getPassiveSegmentsCreationResult().getPnr())).map(p -> p.getPassiveSegmentsCreationResult().getPnr()).collect(Collectors.toSet());
            Set pccList = ((BookingFile)ctx.getRootPane().getData().getContainer().getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> res.getProductUids().contains(p.getUid()) && p.getPassiveSegmentsCreationResult() != null && !TextUtil.isBlank((String)p.getPassiveSegmentsCreationResult().getPcc())).map(p -> p.getPassiveSegmentsCreationResult().getPcc()).collect(Collectors.toSet());
            if (!res.isNewReservation()) {
                if (pnrList.size() > 1 || pnrList.size() == 1 && !TextUtil.isSame((String)res.getPnr(), (String)((String)pnrList.iterator().next()), (boolean)true)) {
                    dupe1Msg = L10n.replace((String)Messages.PassiveSegmentsDupe, (Object[])new Object[]{pnrList});
                    confirmMsg = L10n.replace((String)Messages.PassiveSegmentsConfirmation, (Object[])new Object[]{res.getPnr()});
                }
                if (!pccList.isEmpty() && pnrList.isEmpty()) {
                    dupe2Msg = L10n.replace((String)Messages.PassiveSegmentsDupe2, (Object[])new Object[]{pccList});
                    confirmMsg = L10n.replace((String)Messages.PassiveSegmentsConfirmation, (Object[])new Object[]{res.getPnr()});
                }
            } else if (res.isNewReservation()) {
                if (!pnrList.isEmpty()) {
                    dupe1Msg = L10n.replace((String)Messages.PassiveSegmentsDupe, (Object[])new Object[]{pnrList});
                    confirmMsg = L10n.replace((String)Messages.PassiveSegmentsConfirmation2, (Object[])new Object[]{res.getPcc()});
                }
                if (!pccList.isEmpty()) {
                    dupe2Msg = L10n.replace((String)Messages.PassiveSegmentsDupe2, (Object[])new Object[]{pccList});
                    confirmMsg = L10n.replace((String)Messages.PassiveSegmentsConfirmation2, (Object[])new Object[]{res.getPcc()});
                }
            }
            if (!confirmMsg.equals("")) {
                String textBody = "";
                if (dupe1Msg != null) {
                    textBody = dupe1Msg;
                }
                if (dupe2Msg != null) {
                    textBody = textBody.equals("") ? dupe2Msg : textBody + "\n" + dupe2Msg;
                }
                String finalTextBody = textBody;
                String finalConfirmMsg = confirmMsg;
                FxUtil.waitForFxThread(() -> {
                    InfoLabelWidget infoLabelWidget = new InfoLabelWidget();
                    infoLabelWidget.setDefaultText(finalTextBody);
                    Dialog confirmDialog = new Dialog();
                    confirmDialog.setTitle(Messages.Dialog_confirm).setExpandToParent(false).setBody((Node)infoLabelWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, finalConfirmMsg, () -> Notifications.get().submitTask(() -> {
                        ArrayList<Message> msgs = new ArrayList<Message>();
                        this.createPassiveSegments((EntityContainer<BookingFile>)ctx.getRootPane().getData().getContainer(), res, msgs);
                        Notifications.get().showMessages(msgs);
                    }, Messages.PassiveSegments_creating)).show((Node)ctx.getProductsWidget());
                });
            } else {
                ArrayList<Message> msgs = new ArrayList<Message>();
                this.createPassiveSegments((EntityContainer<BookingFile>)ctx.getRootPane().getData().getContainer(), res, msgs);
                Notifications.get().showMessages(msgs);
            }
        }, Messages.PassiveSegments_creating);
        dialog.close();
    }

    public static class ProductTableVM {
        private String productName;
        private String productUID;
        private boolean checked;

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String product) {
            this.productName = product;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String productUID) {
            this.productUID = productUID;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }
    }
}

